/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.aspects;

import com.sonicsw.esb.aspects.AspectsConfigBean;
import com.sonicsw.xq.XQInitContext;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQService;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xqimpl.service.bpe.ProcessEntryService;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.lang.reflect.Method;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.support.DynamicMethodMatcherPointcut;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class DynamicPointcut
extends DynamicMethodMatcherPointcut
implements BeanFactoryAware {
    private XQLog m_log = XQLogImpl.getCategoryLog((int)1024);
    private String m_capturedServiceName;
    private AspectsConfigBean m_filter;

    public DynamicPointcut(AspectsConfigBean b) {
        this.m_filter = b;
    }

    public void setBeanFactory(BeanFactory f) {
    }

    public boolean matches(Method method, Class cls) {
        if (this.m_filter.getServiceName() != null && this.m_capturedServiceName != null) {
            return this.m_capturedServiceName.equals(this.m_filter.getServiceName());
        }
        return true;
    }

    public boolean matches(Method method, Class cls, Object[] args) {
        boolean result = false;
        if (!this.matches(method, cls)) {
            result = false;
        } else if ("init".equals(method.getName())) {
            XQInitContext ic = (XQInitContext)args[0];
            XQParameters p = ic.getParameters();
            this.m_capturedServiceName = p.getParameter("SonicXQ.ServiceName", 1);
            result = this.matches(method, cls);
        } else if ("service".equals(method.getName())) {
            if (this.m_filter.getProcessName() == null) {
                result = true;
            } else {
                XQServiceContext sc = (XQServiceContext)args[0];
                if (sc.getProcessContext() == null) {
                    result = false;
                } else {
                    String pName = sc.getProcessContext().getName();
                    String pStep = sc.getProcessContext().getStepName();
                    result = this.m_filter.getStepName() == null ? pName.equals(this.m_filter.getProcessName()) : pName.equals(this.m_filter.getProcessName()) && pStep.equals(this.m_filter.getStepName());
                }
            }
        } else {
            result = true;
        }
        this.m_log.logDebug("DynamicPointcut: service=" + this.m_capturedServiceName + " method=" + method.getName() + " result=" + result);
        return result;
    }

    public ClassFilter getClassFilter() {
        return new ClassFilter(){

            public boolean matches(Class cls) {
                return XQService.class.isAssignableFrom(cls) && cls != ProcessEntryService.class;
            }
        };
    }
}

