/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.def.el;

import com.sonicsw.esb.expression.def.el.ExpressionDefProcessorBase;
import com.sonicsw.xqimpl.util.ClassUtils;
import java.util.ArrayList;

public class FunctionDef {
    private String functionName;
    private Object[] functionParams;

    public String getName() {
        return this.functionName;
    }

    public void setName(String functionName) {
        this.functionName = functionName;
    }

    public Object[] getParams() {
        return this.functionParams;
    }

    public void setParams(Object[] functionParams) {
        this.functionParams = ClassUtils.arrayCopy((Object[])functionParams);
    }

    void fixParams() {
        for (int i = 0; i < this.functionParams.length; ++i) {
            if (!(this.functionParams[i] instanceof String)) continue;
            String functionParam = (String)this.functionParams[i];
            String param = functionParam.trim();
            if ("null".equals(param)) {
                this.functionParams[i] = null;
                continue;
            }
            if (param.startsWith("'") && param.endsWith("'")) {
                param = param.substring(1, param.length() - 1);
                this.functionParams[i] = param;
                continue;
            }
            this.functionParams[i] = param.trim();
        }
    }

    static FunctionDef parse(String function) {
        FunctionDef functionDef = new FunctionDef();
        int leftParanthesisIndex = function.indexOf(40);
        functionDef.setName(function.substring(0, leftParanthesisIndex));
        int rightParanthesisIndex = function.lastIndexOf(41);
        String paramsStr = function.substring(leftParanthesisIndex + 1, rightParanthesisIndex);
        ArrayList<Object> paramsList = new ArrayList<Object>();
        String param = null;
        while (true) {
            int index;
            if ((index = paramsStr.indexOf(44)) == -1) break;
            param = paramsStr.substring(0, index).trim();
            if (param.startsWith("xq:")) {
                index = paramsStr.lastIndexOf(41) + 1;
                param = paramsStr.substring(0, index);
                paramsList.add(ExpressionDefProcessorBase.getExpressionObjOrStr(param));
            } else {
                paramsList.add(ExpressionDefProcessorBase.getExpressionObjOrStr(param));
            }
            paramsStr = paramsStr.substring(index + 1, paramsStr.length());
        }
        paramsList.add(ExpressionDefProcessorBase.getExpressionObjOrStr(paramsStr));
        functionDef.setParams(paramsList.toArray());
        functionDef.fixParams();
        return functionDef;
    }

    static void addFunction(StringBuilder sbuf, String funcName, Object ... params) {
        sbuf.append(funcName);
        sbuf.append("(");
        boolean firstToken = true;
        for (Object param : params) {
            if (firstToken) {
                firstToken = false;
            } else {
                sbuf.append(", ");
            }
            if (param instanceof String) {
                sbuf.append("'");
            }
            sbuf.append(ExpressionDefProcessorBase.getString(param));
            if (!(param instanceof String)) continue;
            sbuf.append("'");
        }
        sbuf.append(")");
    }
}

