/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.def.el;

import com.sonicsw.esb.expression.def.ExpressionDef;
import com.sonicsw.esb.expression.def.ExpressionDefProcessor;
import com.sonicsw.esb.expression.def.PropsExpressionDef;
import com.sonicsw.esb.expression.def.UnsupportedExpressionDef;
import com.sonicsw.esb.expression.def.el.ExpressionDefProcessorBase;
import com.sonicsw.esb.expression.def.el.FunctionDef;
import com.sonicsw.esb.expression.def.el.IndexConstructProcessor;

public class PropsExpressionDefProcessor
extends ExpressionDefProcessorBase
implements ExpressionDefProcessor,
IndexConstructProcessor.Callback {
    private PropsExpressionDef m_expressionDef;

    public PropsExpressionDefProcessor() {
    }

    public PropsExpressionDefProcessor(String remaining) {
        super(remaining);
        this.m_expressionDef = new PropsExpressionDef();
    }

    @Override
    public ExpressionDef getExpressionDef(String strExpression, boolean isRValue) {
        if (isRValue) {
            return new UnsupportedExpressionDef("Property file expressions cannot be R-Values");
        }
        this.m_expressionDef.setRValue(isRValue);
        IndexConstructProcessor.processIndexConstruct(this.m_remaining, this);
        return this.m_expressionDef;
    }

    @Override
    public String getStringRepresentation(ExpressionDef expressionDef) {
        assert (expressionDef instanceof PropsExpressionDef);
        PropsExpressionDef propsExpressionDef = (PropsExpressionDef)expressionDef;
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("${");
        FunctionDef.addFunction(sbuf, propsExpressionDef.isDynamic() ? "xq:getPropertiesDynamic" : "xq:getProperties", propsExpressionDef.getPropertyFileName());
        sbuf.append("['");
        sbuf.append(PropsExpressionDefProcessor.getString(propsExpressionDef.getPropertyName()));
        sbuf.append("']}");
        return sbuf.toString();
    }

    @Override
    public void setIndex(String index) {
        this.m_expressionDef.setPropertyName(index);
    }

    @Override
    public void setSource(String source) {
        FunctionDef functionDef = FunctionDef.parse(source);
        String functionName = functionDef.getName();
        this.m_expressionDef.setDynamic(functionName.endsWith("Dynamic"));
        Object[] params = functionDef.getParams();
        this.m_expressionDef.setPropertyFileName(params[0]);
    }

    @Override
    public void setFunction(String function) {
    }

    @Override
    public void setIndex(int index) {
    }

    @Override
    public void setEmbeddedExpression(String expression) {
        ExpressionDef expressionDef = this.parseAsExpressionDef(expression);
        this.m_expressionDef.setPropertyName(expressionDef != null ? expressionDef : expression);
    }
}

