/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.process.engine.ProcessInstance;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.process.model.impl.DefaultToken;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class CompositeToken
extends DefaultToken {
    public static final String COMPOSITE_TOKEN_INDEX = "COMPOSITE_TOKEN_INDEX";
    private List<Token> m_tokens = new ArrayList<Token>();
    private int m_index = 0;

    public CompositeToken(ActivityNode fromActivityNode, ProcessInstance procInst) {
        super(fromActivityNode, procInst, null);
    }

    protected void init() {
    }

    public void addToken(Token token) {
        this.m_tokens.add(token);
        token.setProperty(COMPOSITE_TOKEN_INDEX, this.m_index++ + "");
    }

    public List<Token> getTokens() {
        return this.m_tokens;
    }

    public void setTokens(List<Token> tokens) {
        this.m_tokens = tokens;
    }

    public static <T extends EsbMessageExchange> CompositeToken createCompositeToken(ActivityNode node, Token token, T mex, Set<XQAddress> nextAddresses) {
        CompositeToken resultToken = new CompositeToken(node, (ProcessInstance)token.getProcessInstance());
        XQMessage inputMsg = mex.getInputMessage();
        XQMessage newMsg = null;
        boolean firstMsg = true;
        for (XQAddress address : nextAddresses) {
            EsbMessageExchange newMex = (EsbMessageExchange)mex.clone();
            newMex.setDestinationAddress(address);
            if (firstMsg) {
                firstMsg = false;
                newMsg = inputMsg;
            } else {
                newMsg = (XQMessage)inputMsg.clone();
            }
            newMex.setInputMessage(newMsg);
            Token newToken = token.changeOwnership(node, true);
            newToken.setData(newMex);
            resultToken.addToken(newToken);
        }
        return resultToken;
    }
}

