/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.run.handlers.scriptengine.impl;

import com.sonicsw.esb.run.ExporterFactory;
import com.sonicsw.esb.run.handlers.scriptengine.IParameterValueReference;
import com.sonicsw.esb.run.handlers.scriptengine.impl.IExportable;
import com.sonicsw.esb.run.handlers.scriptengine.impl.IRemoteParameterValue;
import com.sonicsw.xqimpl.script.IParameterValue;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import net.jini.export.Exporter;

public class ParameterValueReferenceImpl
implements IExportable,
IParameterValueReference,
Serializable {
    private static final long serialVersionUID = 256802125008660643L;
    private transient IParameterValue m_parameterValue;
    private transient IRemoteParameterValue m_unexportedParameterValue;
    private IRemoteParameterValue m_remoteParameterValue;
    private String m_direction;
    private String m_baseType;
    private String m_displayType;
    private String m_paramName;
    private boolean m_isByteArray;
    private boolean m_isDiscard;
    private boolean m_isXML;
    private transient Exporter m_exporter;
    private transient ExporterFactory m_factory;

    public ParameterValueReferenceImpl(IParameterValue parameterValue, ExporterFactory factory) throws ExportException {
        this.m_parameterValue = parameterValue;
        this.m_factory = factory;
        this.m_baseType = parameterValue.getBaseType();
        this.m_displayType = parameterValue.getDisplayType();
        this.m_paramName = parameterValue.getParamName();
        this.m_isByteArray = parameterValue.isByteArray();
        this.m_isDiscard = parameterValue.isDiscard();
        this.m_isXML = parameterValue.isXML();
        this.m_direction = parameterValue.getDirection().toString();
    }

    @Override
    public void export() throws ExportException {
        this.m_exporter = this.m_factory.createExporter();
        this.m_unexportedParameterValue = new RemoteParameterValueWrapper(this.m_parameterValue);
        this.m_remoteParameterValue = (IRemoteParameterValue)this.m_exporter.export((Remote)this.m_unexportedParameterValue);
    }

    @Override
    public void unexport() {
        this.m_exporter.unexport(false);
    }

    @Override
    public byte[] getAsByteArray() throws RemoteException {
        try {
            return this.m_remoteParameterValue.getAsByteArray();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public String getAsString() throws RemoteException {
        try {
            return this.m_remoteParameterValue.getAsString();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public String getAsStringIncludeXMLHeader() throws RemoteException {
        try {
            return this.m_remoteParameterValue.getAsStringIncludeXMLHeader();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public String getBaseType() {
        return this.m_baseType;
    }

    @Override
    public String getDirection() {
        return this.m_direction;
    }

    @Override
    public String getDisplayType() {
        return this.m_displayType;
    }

    @Override
    public String getParamName() {
        return this.m_paramName;
    }

    @Override
    public boolean isByteArray() {
        return this.m_isByteArray;
    }

    @Override
    public boolean isDiscard() {
        return this.m_isDiscard;
    }

    @Override
    public boolean isXML() {
        return this.m_isXML;
    }

    class RemoteParameterValueWrapper
    implements IRemoteParameterValue {
        private IParameterValue m_value;

        RemoteParameterValueWrapper(IParameterValue value) {
            this.m_value = value;
        }

        @Override
        public byte[] getAsByteArray() throws RemoteException {
            try {
                return this.m_value.getAsByteArray();
            }
            catch (ScriptEngineException e) {
                throw new RemoteException(e.getMessage(), e);
            }
        }

        @Override
        public String getAsString() throws RemoteException {
            try {
                return this.m_value.getAsString();
            }
            catch (ScriptEngineException e) {
                throw new RemoteException(e.getMessage(), e);
            }
        }

        @Override
        public String getAsStringIncludeXMLHeader() throws RemoteException {
            try {
                return this.m_value.getAsStringIncludeXMLHeader();
            }
            catch (ScriptEngineException e) {
                throw new RemoteException(e.getMessage(), e);
            }
        }
    }
}

