/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.run.handlers.service.impl;

import com.sonicsw.esb.interceptor.XQInterceptorServiceContext;
import com.sonicsw.esb.itinerary.engine.ItineraryEngine;
import com.sonicsw.esb.itinerary.engine.XQProcessInstanceSerializer;
import com.sonicsw.esb.run.LocationContext;
import com.sonicsw.esb.run.RunException;
import com.sonicsw.esb.run.handlers.service.XQParametersReference;
import com.sonicsw.esb.run.handlers.service.XQProcessContextReference;
import com.sonicsw.esb.run.handlers.service.impl.XQAddressReference;
import com.sonicsw.esb.run.handlers.service.impl.XQEnvelopeReference;
import com.sonicsw.esb.run.impl.RemoteValue;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQProcessContext;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class XQServiceContextReference
extends RemoteValue
implements com.sonicsw.esb.run.handlers.service.XQServiceContextReference {
    protected final XQInterceptorServiceContext m_serviceContext;

    public XQServiceContextReference(LocationContext locationContext, XQInterceptorServiceContext serviceContext) {
        super(locationContext);
        this.m_serviceContext = serviceContext;
    }

    @Override
    public XQParametersReference getParameters() throws RemoteException {
        try {
            XQParameters parameters = this.m_serviceContext.getParameters();
            if (parameters == null) {
                return null;
            }
            com.sonicsw.esb.run.handlers.service.impl.XQParametersReference paramtersRef = new com.sonicsw.esb.run.handlers.service.impl.XQParametersReference(this.m_locationContext, parameters);
            return (XQParametersReference)this.exportSubObject(paramtersRef);
        }
        catch (RunException e) {
            throw new RemoteException("Method 'getParameters' failed", e);
        }
    }

    @Override
    public List getIncomingMessages() throws RemoteException {
        try {
            LinkedList envelopes = new LinkedList();
            ListIterator it = this.m_serviceContext.inboxIterator();
            return this.fillEnvelopes(envelopes, it);
        }
        catch (RunException e) {
            throw new RemoteException("Method 'getIncomingMessages' failed", e);
        }
    }

    @Override
    public List getOutgoingMessages() throws RemoteException {
        try {
            LinkedList envelopes = new LinkedList();
            ListIterator it = this.m_serviceContext.outboxIterator();
            return this.fillEnvelopes(envelopes, it);
        }
        catch (RunException e) {
            throw new RemoteException("Method 'getIncomingMessages' failed", e);
        }
    }

    @Override
    public List getFaultMessages() throws RemoteException {
        try {
            LinkedList envelopes = new LinkedList();
            ListIterator it = this.m_serviceContext.faultboxIterator();
            return this.fillEnvelopes(envelopes, it);
        }
        catch (RunException e) {
            throw new RemoteException("Method 'getIncomingMessages' failed", e);
        }
    }

    private List fillEnvelopes(List envelopes, Iterator it) throws RunException {
        while (it.hasNext()) {
            XQEnvelope envelope = (XQEnvelope)it.next();
            envelope = this.stripBPHeaders(envelope);
            XQEnvelopeReference envelopeRef = new XQEnvelopeReference(this.m_locationContext, envelope);
            envelopes.add(this.exportSubObject(envelopeRef));
        }
        return envelopes;
    }

    private XQEnvelope stripBPHeaders(XQEnvelope env) {
        XQMessage msg = env.getMessage();
        if (ItineraryEngine.hasProcessState(msg)) {
            XQEnvelope result = (XQEnvelope)env.clone();
            msg = (XQMessage)msg.clone();
            XQProcessInstanceSerializer.stripProcessState(msg);
            result.setMessage(msg);
            return result;
        }
        return env;
    }

    public boolean hasNextIncoming() throws RemoteException {
        return this.m_serviceContext.hasNextIncoming();
    }

    public XQEnvelopeReference getNextIncoming() throws RemoteException {
        try {
            XQEnvelope envelope = this.m_serviceContext.getNextIncoming();
            return this.stripAndExport(envelope);
        }
        catch (RunException e) {
            throw new RemoteException("Method 'getNextIncoming' failed", e);
        }
    }

    public XQEnvelopeReference getFirstIncoming() throws RemoteException {
        try {
            XQEnvelope envelope = this.m_serviceContext.getFirstIncoming();
            return this.stripAndExport(envelope);
        }
        catch (RunException e) {
            throw new RemoteException("Method 'getFirstIncoming' failed", e);
        }
    }

    private XQEnvelopeReference stripAndExport(XQEnvelope envelopeParam) throws RunException {
        XQEnvelope envelope = envelopeParam;
        if (envelope == null) {
            return null;
        }
        envelope = this.stripBPHeaders(envelope);
        XQEnvelopeReference envelopeRef = new XQEnvelopeReference(this.m_locationContext, envelope);
        return (XQEnvelopeReference)this.exportSubObject(envelopeRef);
    }

    @Override
    public int getCurrentListener() throws RemoteException {
        return this.m_serviceContext.getCurrentListener();
    }

    @Override
    public String getEntryEndpoint() throws RemoteException {
        return this.m_serviceContext.getEntryEndpoint();
    }

    @Override
    public com.sonicsw.esb.run.handlers.service.XQAddressReference getRMEAddress() throws RemoteException {
        try {
            XQAddress rmeAddress = this.m_serviceContext.getRMEAddress();
            if (rmeAddress == null) {
                return null;
            }
            XQAddressReference rmeAddressRef = new XQAddressReference(this.m_locationContext, rmeAddress);
            return (com.sonicsw.esb.run.handlers.service.XQAddressReference)this.exportSubObject(rmeAddressRef);
        }
        catch (RunException e) {
            throw new RemoteException("Method 'getProcessContext' failed", e);
        }
    }

    @Override
    public XQProcessContextReference getProcessContext() throws RemoteException {
        try {
            XQProcessContext processContext = this.m_serviceContext.getProcessContext();
            if (processContext == null) {
                return null;
            }
            com.sonicsw.esb.run.handlers.service.impl.XQProcessContextReference processContextRef = new com.sonicsw.esb.run.handlers.service.impl.XQProcessContextReference(this.m_locationContext, processContext);
            return (XQProcessContextReference)this.exportSubObject(processContextRef);
        }
        catch (RunException e) {
            throw new RemoteException("Method 'getProcessContext' failed", e);
        }
    }
}

