/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.bpe;

import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQAddressFactory;
import com.sonicsw.xq.XQAddressNotFoundException;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQInitContext;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQProcessAddress;
import com.sonicsw.xq.XQService;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xqimpl.envelope.XQAddressFactoryImpl;

public class ProcessEntryService
implements XQService {
    private String m_processName;

    public void init(XQInitContext initialContext) throws XQServiceException {
        this.m_processName = initialContext.getParameters().getParameter("process", 1);
        if (this.m_processName == null || "".equals(this.m_processName.trim())) {
            throw new XQServiceException("ProcessEntryService requires a process parameter");
        }
    }

    public void service(XQServiceContext context) throws XQServiceException {
        XQEnvelope envelope = context.getNextIncoming();
        envelope.clearAddresses();
        String process = context.getParameters().getParameter("process", 1);
        if (process == null || "".equals(process.trim())) {
            process = this.m_processName;
        }
        try {
            XQAddressFactory factory = context.getAddressFactory();
            XQAddressFactoryImpl factoryImpl = (XQAddressFactoryImpl)factory;
            XQProcessAddress addr = factoryImpl.createSingleUseProcessAddress(process);
            XQMessage msg = envelope.getMessage();
            this.checkOverrides(msg, addr, factory);
            envelope.addAddress((XQAddress)addr);
            context.addOutgoing(envelope);
        }
        catch (XQAddressNotFoundException anfe) {
            throw new XQServiceException("Unable to find process:" + process, (Throwable)anfe);
        }
    }

    public void destroy() {
    }

    private void checkOverrides(XQMessage msg, XQProcessAddress processAddr, XQAddressFactory factory) throws XQServiceException {
        if (processAddr == null || factory == null) {
            return;
        }
        String param = null;
        XQAddress addr = null;
        int delim = 58;
        int delimIndex = -1;
        try {
            String type;
            String addrName;
            if (msg.containsHeader("SonicXQ.process.RMEAddress")) {
                param = msg.getStringHeader("SonicXQ.process.RMEAddress");
                msg.removeHeader("SonicXQ.process.RMEAddress");
                if (param == null || "".equals(param.trim())) {
                    processAddr.setRMEAddress(null);
                } else {
                    delimIndex = param.indexOf(58);
                    if (delimIndex != -1) {
                        addrName = param.substring(0, delimIndex);
                        type = param.substring(delimIndex + 1);
                        addr = factory.createAddress(addrName, type);
                        processAddr.setRMEAddress(addr);
                    } else {
                        throw new XQServiceException("Invalid override header: " + param);
                    }
                }
            }
            if (msg.containsHeader("SonicXQ.process.faultAddress")) {
                param = msg.getStringHeader("SonicXQ.process.faultAddress");
                msg.removeHeader("SonicXQ.process.faultAddress");
                if (param == null || "".equals(param.trim())) {
                    processAddr.setFaultAddress(null);
                } else {
                    delimIndex = param.indexOf(58);
                    if (delimIndex != -1) {
                        addrName = param.substring(0, delimIndex);
                        type = param.substring(delimIndex + 1);
                        addr = factory.createAddress(addrName, type);
                        processAddr.setFaultAddress(addr);
                    } else {
                        throw new XQServiceException("Invalid override header: " + param);
                    }
                }
            }
            if (msg.containsHeader("SonicXQ.process.trackingLevel")) {
                param = msg.getStringHeader("SonicXQ.process.trackingLevel");
                msg.removeHeader("SonicXQ.process.trackingLevel");
                int level = Integer.parseInt(param);
                if (level < 0 || level > 5) {
                    throw new XQServiceException("Invalid tracking level");
                }
                processAddr.setTrackingLevel(level);
            }
            if (msg.containsHeader("SonicXQ.process.trackingID")) {
                param = msg.getStringHeader("SonicXQ.process.trackingID");
                msg.removeHeader("SonicXQ.process.trackingID");
                processAddr.setTrackingID(param);
            }
            if (msg.containsHeader("SonicXQ.process.eventAddress")) {
                param = msg.getStringHeader("SonicXQ.process.eventAddress");
                msg.removeHeader("SonicXQ.process.eventAddress");
                if (param == null || "".equals(param.trim())) {
                    processAddr.setEventAddress(null);
                } else {
                    delimIndex = param.indexOf(58);
                    if (delimIndex != -1) {
                        addrName = param.substring(0, delimIndex);
                        type = param.substring(delimIndex + 1);
                        addr = factory.createAddress(addrName, type);
                        processAddr.setEventAddress(addr);
                    } else {
                        throw new XQServiceException("Invalid override header: " + param);
                    }
                }
            }
            if (msg.containsHeader("SonicXQ.process.TTL")) {
                param = msg.getStringHeader("SonicXQ.process.TTL");
                msg.removeHeader("SonicXQ.process.TTL");
                long ttl = Long.parseLong(param);
                processAddr.setTTL(ttl);
            }
        }
        catch (XQServiceException xqse) {
            throw xqse;
        }
        catch (Exception e) {
            throw new XQServiceException("Error processing process overrides", (Throwable)e);
        }
    }
}

