/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.endpoint.container;

import com.sonicsw.xq.XQEndpoint;
import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.connector.jms.JMSEndpoint;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.endpoint.container.EndpointManager;
import com.sonicsw.xqimpl.endpoint.container.IEndpointRegistry;
import java.util.Hashtable;
import javax.jms.Destination;
import progress.message.jclient.Topic;

public class InvocationEndpointManager
implements IEndpointRegistry {
    private Hashtable m_endpointRegistry = new Hashtable();

    @Override
    public XQEndpoint getEndpoint(String name) throws XQEndpointCreationException {
        XQEndpoint result = (XQEndpoint)this.m_endpointRegistry.get(name);
        if (result != null) {
            return result;
        }
        try {
            return EndpointManager.getInstance().getEndpoint(name);
        }
        catch (XQEndpointCreationException t) {
            result = this.getTemporaryFaultRMEOrExitEndpoint(name);
            if (result != null) {
                return result;
            }
            throw t;
        }
    }

    private XQEndpoint getTemporaryFaultRMEOrExitEndpoint(String name) {
        if (name.indexOf("ClientTmp") != -1 || name.indexOf("AsynchTmp") != -1) {
            try {
                XQEndpoint source = this.getEndpoint("ESB.source.endpoint");
                if (source == null) {
                    return null;
                }
                XQEndpointConfig sourceEndpointConfig = ((JMSEndpoint)source).getConfig();
                XQEndpointConfig endpointConfig = EndpointManager.getInstance().createEndpointConfig(sourceEndpointConfig, (Destination)new Topic(name), false);
                return EndpointManager.getInstance().createUnregisteredEndpoint(endpointConfig, true, null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void unregisterEndpoint(String name) {
        this.m_endpointRegistry.remove(name);
    }

    public void registerEndpoint(String name, Endpoint endpoint) {
        this.m_endpointRegistry.put(name, endpoint);
    }
}

