/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.envelope;

import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQAddressFactory;
import com.sonicsw.xq.XQAddressNotFoundException;
import com.sonicsw.xq.XQEndpoint;
import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQProcessAddress;
import com.sonicsw.xqimpl.common.XQAbstractAddressImpl;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQConfiguration;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.config.XQGlobalConfig;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.endpoint.container.EndpointManager;
import com.sonicsw.xqimpl.endpoint.container.InvocationEndpointManager;
import com.sonicsw.xqimpl.envelope.IXQAddressImpl;
import com.sonicsw.xqimpl.envelope.XQAddressImpl;
import com.sonicsw.xqimpl.envelope.XQProcessAddressImpl;
import com.sonicsw.xqimpl.service.XQEndpointManagerImpl;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.JMSException;

public class XQAddressFactoryImpl
implements XQAddressFactory {
    private static IXQAddressImpl s_replyTo;
    private static IXQAddressImpl s_globalRME;
    private IXQAddressImpl m_self;
    private XQEndpointManagerImpl m_endpointManager;
    private static XQLog s_log;

    public XQAddressFactoryImpl(String selfName, int type, XQEndpointManagerImpl endpointManager) {
        if (null != selfName) {
            this.m_self = new XQAddressImpl(selfName, type);
        }
        this.m_endpointManager = endpointManager;
    }

    public XQAddressFactoryImpl(String selfName, int type) {
        this(selfName, type, null);
    }

    public XQAddress createAddress(String name, int type) throws XQAddressNotFoundException {
        if ("REPLY_TO".equals(name)) {
            return s_replyTo;
        }
        return new XQAddressImpl(name, type, this.lookupConfigObject(name, type));
    }

    public XQAddress createAddress(String name, String type) throws XQAddressNotFoundException {
        if ("REPLY_TO".equals(name)) {
            return s_replyTo;
        }
        return new XQAddressImpl(name, type, this.lookupConfigObject(name, type));
    }

    public XQAddress createAddress(String name, String type, XQConfiguration config) throws XQAddressNotFoundException {
        if ("REPLY_TO".equals(name)) {
            return s_replyTo;
        }
        return new XQAddressImpl(name, type, config);
    }

    public IXQAddressImpl createAddress(XQEndpointConfig source, Destination destination, boolean isReplyTo) throws XQAddressNotFoundException {
        return this.createAddress(source, destination, null, null, isReplyTo);
    }

    public IXQAddressImpl createInvocationEndpointAddress(XQEndpointConfig source, Destination destination, String nameOverride, boolean isReplyTo, InvocationEndpointManager iem) throws XQAddressNotFoundException {
        XQAddressImpl result = null;
        if (destination != null && source != null) {
            EndpointManager endpointManager = EndpointManager.getInstance();
            XQEndpointConfig endpointConfig = null;
            String name = null;
            try {
                endpointConfig = endpointManager.createEndpointConfig(source, destination, isReplyTo);
                if (nameOverride != null) {
                    endpointConfig.setName(nameOverride);
                }
                name = endpointConfig.getName();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            try {
                Endpoint endpoint = endpointManager.createUnregisteredEndpoint(endpointConfig, true, null, null);
                iem.registerEndpoint(name, endpoint);
                result = name == null ? null : new XQAddressImpl(name, 0);
            }
            catch (XQEndpointCreationException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public IXQAddressImpl createAddress(XQEndpointConfig source, Destination destination, XQConnectionConfig connectionConfig, Hashtable props, boolean isReplyTo) throws XQAddressNotFoundException {
        XQAddressImpl result = null;
        try {
            if (destination != null && source != null) {
                XQEndpointConfig endpointConfig;
                String name;
                EndpointManager endpointManager = EndpointManager.getInstance();
                if (!endpointManager.isEndpointDefined(name = (endpointConfig = endpointManager.createEndpointConfig(source, destination, isReplyTo)).getName())) {
                    endpointManager.createEndpoint(endpointConfig, true, connectionConfig, props);
                }
                result = name == null ? null : new XQAddressImpl(name, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public XQAddress createEndpointAddress(String name) throws XQAddressNotFoundException {
        return new XQAddressImpl(name, 0, this.lookupConfigObject(name, 0));
    }

    public XQAddress createServiceAddress(String name) throws XQAddressNotFoundException {
        return new XQAddressImpl(name, 1, this.lookupConfigObject(name, 1));
    }

    public XQProcessAddress createProcessAddress(String name) throws XQAddressNotFoundException {
        return new XQProcessAddressImpl(name, (XQProcessConfig)this.lookupConfigObject(name, 2));
    }

    public XQProcessAddress createProcessAddress(String name, String step) throws XQAddressNotFoundException {
        return new XQProcessAddressImpl(name, step, (XQProcessConfig)this.lookupConfigObject(name, 2));
    }

    public XQProcessAddress createSingleUseProcessAddress(String name) throws XQAddressNotFoundException {
        XQProcessAddressImpl processAddress = new XQProcessAddressImpl(name, (XQProcessConfig)this.lookupConfigObject(name, 2));
        processAddress.setSingleUseAddress(true);
        return processAddress;
    }

    public XQProcessAddress createSingleUseProcessAddress(String name, String step) throws XQAddressNotFoundException {
        XQProcessAddressImpl processAddress = new XQProcessAddressImpl(name, step, (XQProcessConfig)this.lookupConfigObject(name, 2));
        processAddress.setSingleUseAddress(true);
        return processAddress;
    }

    public XQAddress getReplyToAddress() {
        return s_replyTo;
    }

    public static XQAddress getReplyToStatic() {
        return s_replyTo;
    }

    public static XQAddress getGlobalRME() {
        return s_globalRME;
    }

    public XQAddress getSelfAddress() {
        return this.m_self;
    }

    private XQConfiguration lookupConfigObject(String name, String type) throws XQAddressNotFoundException {
        return this.lookupConfigObject(name, XQAbstractAddressImpl.getTypeAsInt((String)type));
    }

    private XQConfiguration lookupConfigObject(String name, int addressType) throws XQAddressNotFoundException {
        try {
            XQEndpoint transientEP;
            if (addressType == 0 && this.m_endpointManager != null && (transientEP = this.m_endpointManager.getTransientEndpoint(name)) != null) {
                return ((Endpoint)transientEP).getConfig();
            }
            XQConfigManager configManager = XQConfigManager.getInstance(null);
            return (XQConfiguration)configManager.lookup(name, this.getConfigTypeFromAddressType(addressType));
        }
        catch (Exception e) {
            throw new XQAddressNotFoundException("Cannot locate address " + this.toString() + " in Directory Service.", e);
        }
    }

    private String getConfigTypeFromAddressType(int addressType) {
        switch (addressType) {
            case 1: {
                return "service";
            }
            case 2: {
                return "process";
            }
        }
        return "endpoint";
    }

    public XQAddress parseAddress(String address) {
        return new XQAddressImpl(address);
    }

    public IXQAddressImpl createInvocationEndpointAddress(XQEndpointConfig source, Destination destination, boolean isReplyTo, InvocationEndpointManager iem) throws XQAddressNotFoundException {
        return this.createInvocationEndpointAddress(source, destination, null, isReplyTo, iem);
    }

    static {
        s_log = XQLogImpl.getInstance();
        s_replyTo = new XQAddressImpl();
        s_replyTo.setName("REPLY_TO");
        s_replyTo.setType(3);
        String globalRME = null;
        XQGlobalConfig globalCfg = XQGlobalConfig.getGlobalConfig();
        if (globalCfg != null) {
            globalRME = globalCfg.getGlobalRME();
        }
        if (globalRME != null && globalRME.trim().length() > 0) {
            try {
                s_globalRME = new XQAddressImpl(globalRME);
                s_log.logInformation("The global RME destination is set to `" + s_globalRME + "`");
            }
            catch (Throwable e) {
                s_log.logError("Invalid address `" + globalRME + "` specified for the global RME");
                s_log.logDebug(e);
                throw new IllegalArgumentException("Invalid address `" + globalRME + "` specified for the global RME", e);
            }
        }
    }
}

