/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.invkimpl.wsif.providers.esb;

import com.sonicsw.esb.visitor.ESBVisitor;
import com.sonicsw.esb.visitor.ESBVisitorContext;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xq.connector.jms.JMSEndpoint;
import com.sonicsw.xq.connector.jms.XQJMSMessage;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.BaseEsbWsifJmsDestination;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.GeneralWSInvocationException;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.w3c.dom.Node;

public class ESBWSIFJMSDestination
extends BaseEsbWsifJmsDestination {
    private static XQLog log = XQLogImpl.getCategoryLog((int)32);

    public ESBWSIFJMSDestination(String location) throws WSIFException {
        super(location);
    }

    public XQMessage createXQMessage(WSIFMessage inMsg) throws WSIFException {
        XQJMSMessage xqMsg = null;
        try {
            xqMsg = new XQJMSMessage();
            xqMsg = this.setJMSProperties(xqMsg);
            XQAddress ESBReplyTo = (XQAddress)this.inProps.get("ESBReplyTo");
            String ESBCorrelationId = (String)this.inProps.get("{http://www.sonicsw.com/esb}ESBCorrelationId");
            ESBVisitor visitor = (ESBVisitor)this.inProps.get("com.sonicsw.esb.visitor");
            ESBVisitorContext actionalContext = (ESBVisitorContext)this.inProps.get("com.sonicsw.esb.visitor.ActionalContext");
            xqMsg.setReplyTo(ESBReplyTo);
            if (ESBCorrelationId != null) {
                xqMsg.setCorrelationId(ESBCorrelationId);
            }
            xqMsg.setVisitor(visitor);
            if (actionalContext != null) {
                xqMsg.addSidebandProperty("ESBVisitor.PARAM_RUNTIME_CONTEXT", actionalContext.clone());
            }
            Iterator i = inMsg.getPartNames();
            while (i.hasNext()) {
                String partName = (String)i.next();
                Object partValue = inMsg.getObjectPart(partName);
                XQPart part = null;
                if (partValue instanceof Node) {
                    StringWriter writer = new StringWriter();
                    DOMUtils.serializeNodeToWriter((Node)((Node)partValue), (Writer)writer);
                    String textValue = writer.toString();
                    part = xqMsg.createPart(textValue, "text/xml");
                } else {
                    part = xqMsg.createPart(partValue, "text/plain");
                }
                part.setContentId(partName);
                xqMsg.addPart(part);
            }
        }
        catch (XQMessageException ex) {
            throw new GeneralWSInvocationException("xq-message-create-failed", null, ex);
        }
        catch (IOException ioe) {
            throw new GeneralWSInvocationException(ioe.toString(), null, ioe);
        }
        return xqMsg;
    }

    public void send(WSIFMessage inMsg) throws WSIFException {
        log.logDebug("Invoking one-way ESB binding callout....");
        try {
            ((JMSEndpoint)this.getEndpoint()).asyncWSInvokeWithQoS(this.getQos(), this.createRequestMessage(inMsg));
            log.logDebug("Done invoking one-way ESB binding callout.");
        }
        catch (GeneralWSInvocationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new GeneralWSInvocationException(ex.getMessage(), null, ex);
        }
    }

    private XQMessage createRequestMessage(WSIFMessage inMsg) throws WSIFException, XQMessageException {
        XQMessage xqRequestMessage = this.createXQMessage(inMsg);
        if (log.isDebugLoggingEnabled()) {
            log.logDebug("ESB binding XQRequestMessage part(0)=" + xqRequestMessage.getPart(0).getContent());
        }
        return xqRequestMessage;
    }

    private XQQualityofService getQos() {
        int qos = (Integer)this.inProps.get("com_sonicsw_xqimpl_invk_ESBConstants_ESBQualityofService") == null ? 0 : (Integer)this.inProps.get("com_sonicsw_xqimpl_invk_ESBConstants_ESBQualityofService");
        XQQualityofService qosObj = XQQualityofService.valueOf((int)qos);
        return qosObj;
    }

    public XQMessage call(WSIFMessage inMsg) throws WSIFException {
        try {
            XQMessage xqResponseMessage = ((JMSEndpoint)this.getEndpoint()).syncWSInvokeWithQoS(this.createRequestMessage(inMsg), this.getTimeout(), this.getQos());
            this.setOutMessage(xqResponseMessage);
            if (log.isDebugLoggingEnabled()) {
                log.logDebug("Received ESB binding response XQMessage, part(0)=" + xqResponseMessage.getPart(0).getContent());
            }
            return xqResponseMessage;
        }
        catch (GeneralWSInvocationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new GeneralWSInvocationException(ex.getMessage(), null, ex);
        }
    }

    private long getTimeout() {
        long timeout = (Long)this.inProps.get("com_sonicsw_xqimpl_invk_ESBConstants_ESBRequestTimeout") == 0L ? 90L : (Long)this.inProps.get("com_sonicsw_xqimpl_invk_ESBConstants_ESBRequestTimeout") * 1000L;
        return timeout;
    }
}

