/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script;

import com.sonicsw.xqimpl.script.IScriptCommand;
import com.sonicsw.xqimpl.script.Parameter;
import com.sonicsw.xqimpl.script.ParameterDirection;
import com.sonicsw.xqimpl.script.ParameterValueFactory;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import com.sonicsw.xqimpl.script.ScriptObject;
import com.sonicsw.xqimpl.util.DOMUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseScriptCommand
implements IScriptCommand {
    private List m_parameterList = new ArrayList();
    private HashMap m_outParameterMap = new HashMap();
    private ParameterValueFactory m_factory;
    private ScriptObject m_script;

    public BaseScriptCommand(Element scriptCommand) throws ScriptEngineException {
        this.deserializeScriptCommand(scriptCommand);
    }

    @Override
    public ParameterValueFactory getParameterValueFactory() {
        return this.getParameterValueFactory(this.m_script != null ? this.m_script.getEncoding() : null);
    }

    private ParameterValueFactory getParameterValueFactory(String encoding) {
        if (this.m_factory == null) {
            this.m_factory = new ParameterValueFactory(true, encoding);
        }
        return this.m_factory;
    }

    @Override
    public void setParameterValueFactory(ParameterValueFactory factory) {
        this.m_factory = factory;
    }

    @Override
    public void setScriptObject(ScriptObject obj) {
        this.m_script = obj;
    }

    protected boolean hasInputParameterMapping(String parameterName) {
        if (this.m_script != null) {
            return this.m_script.hasInputParameterMapping(parameterName);
        }
        return false;
    }

    protected boolean hasOutputParameterMapping(String parameterName) {
        if (this.m_script != null) {
            return this.m_script.hasOutputParameterMapping(parameterName);
        }
        return false;
    }

    private void deserializeScriptCommand(Element scriptElm) throws ScriptEngineException {
        Element tempEl = DOMUtils.getImmediateChildElementByName((Element)scriptElm, (String)"parameterList");
        if (tempEl == null) {
            return;
        }
        NodeList tempNl = tempEl.getChildNodes();
        for (int i = 0; i < tempNl.getLength(); ++i) {
            Node n = tempNl.item(i);
            if (!(n instanceof Element) || !n.getLocalName().equals("parameter")) continue;
            Element e = (Element)n;
            Parameter param = new Parameter();
            String name = e.getAttribute("name");
            if (name == null) {
                throw new ScriptEngineException("scriptcommand-param-name-not-found", 1);
            }
            param.setName(name);
            param.setDisplayType(e.getAttribute("displayType"));
            String baseType = e.getAttribute("baseType");
            if (baseType == null) {
                throw new ScriptEngineException("scriptcommand-param-base-type-not-found", new Object[]{name}, 1);
            }
            param.setBaseType(e.getAttribute("baseType"));
            String direction = e.getAttribute("direction");
            if (direction == null) {
                throw new ScriptEngineException("scriptcommand-param-direction-not-found", new Object[]{name}, 1);
            }
            ParameterDirection pd = ParameterDirection.valueOf(direction);
            param.setDirection(pd);
            this.m_parameterList.add(param);
            if (pd != ParameterDirection.OUT && pd != ParameterDirection.INOUT) continue;
            this.m_outParameterMap.put(param.getName(), param);
        }
    }

    @Override
    public List getParameters() {
        return this.m_parameterList;
    }

    @Override
    public Map getOutParameterMap() {
        return this.m_outParameterMap;
    }
}

