/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script;

import com.sonicsw.xqimpl.script.ParameterValue;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import com.sonicsw.xqimpl.util.HexBin;
import java.io.UnsupportedEncodingException;
import org.w3c.dom.Element;

public class HexByteArrayParameterValue
extends ParameterValue {
    private String m_stringValue;
    private byte[] m_byteArrayValue = null;

    public HexByteArrayParameterValue(String paramName, byte[] value) {
        super(paramName);
        if (value == null) {
            this.m_stringValue = "";
        } else {
            this.m_byteArrayValue = value;
        }
    }

    public HexByteArrayParameterValue(String paramName, String value) throws ScriptEngineException {
        super(paramName);
        if (value != null) {
            try {
                this.m_byteArrayValue = HexBin.decode((byte[])value.getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new ScriptEngineException(e.getMessage(), null, 1);
            }
            if (this.m_byteArrayValue == null) {
                throw new ScriptEngineException("parameter-not-hex-encoded", new Object[]{paramName}, 1);
            }
        } else {
            value = "";
        }
        this.m_stringValue = value;
    }

    @Override
    public byte[] getAsByteArray() throws ScriptEngineException {
        return this.m_byteArrayValue;
    }

    @Override
    public String getAsString() {
        if (this.m_stringValue != null) {
            return this.m_stringValue;
        }
        if (this.m_byteArrayValue != null) {
            byte[] hexEncoded = HexBin.encode((byte[])this.m_byteArrayValue);
            this.m_stringValue = new String(hexEncoded);
            return this.m_stringValue;
        }
        return null;
    }

    @Override
    public Element getAsElement() throws ScriptEngineException {
        throw new ScriptEngineException("byte-array-element-mismatch", 2);
    }

    @Override
    public boolean isByteArray() {
        return true;
    }

    @Override
    public boolean isXML() {
        return false;
    }
}

