/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service.debug;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Proxy;

public class DebugObjectInputStream
extends ObjectInputStream {
    public DebugObjectInputStream() throws IOException, StreamCorruptedException {
    }

    public DebugObjectInputStream(InputStream in) throws IOException, StreamCorruptedException {
        super(in);
    }

    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        return Class.forName(v.getName(), true, ccl);
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Class[] classObjs = new Class[interfaces.length];
        int currentValidCount = 0;
        for (int i = 0; i < interfaces.length; ++i) {
            try {
                Class<?> cl;
                classObjs[currentValidCount] = cl = Class.forName(interfaces[i], false, ccl);
                ++currentValidCount;
                continue;
            }
            catch (Exception cl) {
                // empty catch block
            }
        }
        Class[] validClassObjs = new Class[currentValidCount];
        System.arraycopy(classObjs, 0, validClassObjs, 0, currentValidCount);
        if (currentValidCount == 0) {
            throw new ClassNotFoundException("Unable to locate interface for Debug object");
        }
        try {
            return Proxy.getProxyClass(ccl, validClassObjs);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

