/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service.wsinvk;

import com.sonicsw.esb.message.rme.IRMEMessage;
import com.sonicsw.esb.message.rme.RMEMessageFactory;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xqimpl.endpoint.container.EndpointManager;
import com.sonicsw.xqimpl.service.wsinvk.WSExecutionFaultException;
import com.sonicsw.xqimpl.util.log.XQLogImpl;

public final class WSFaultPrescriptionApplicator {
    private static XQLog log = XQLogImpl.getCategoryLog((int)32);

    public static void applyFaultHandlingPrescription(XQServiceContext context, XQMessage message, WSExecutionFaultException wsefe, String sender) throws XQServiceException {
        if (wsefe.getFaultOption() == 1) {
            try {
                XQPart part = message.createPart((Object)wsefe.getAsXML(), "text/xml");
                part.setContentId("SonicESB.Fault");
                message.addPartAt(part, 0);
                context.addFault(message);
            }
            catch (Exception e) {
                throw new XQServiceException((Throwable)e);
            }
        }
        if (wsefe.getFaultOption() == 3) {
            try {
                XQPart part = message.createPart((Object)wsefe.getAsXML(), "text/xml");
                part.setContentId("SonicESB.Fault");
                message.addPartAt(part, 0);
                context.addOutgoing(message);
            }
            catch (Exception e) {
                throw new XQServiceException((Throwable)e);
            }
        }
        if (wsefe.getFaultOption() == 0) {
            XQMessageFactory xqMsgFactory = context.getMessageFactory();
            XQMessage xqFaultMsg = xqMsgFactory.createMessage();
            try {
                XQPart part = message.createPart((Object)wsefe.getAsXML(), "text/xml");
                part.setContentId("SonicESB.Fault");
                xqFaultMsg.addPartAt(part, 0);
                context.addFault(xqFaultMsg);
            }
            catch (Exception e) {
                throw new XQServiceException((Throwable)e);
            }
        }
        if (wsefe.getFaultOption() == 2) {
            try {
                WSFaultPrescriptionApplicator.sendMessageToRME(context, wsefe.getAsXML(), message, "WS_INVOCATION_ERROR", sender);
            }
            catch (Exception e) {
                throw new XQServiceException((Throwable)e);
            }
        }
    }

    protected static boolean sendMessageToRME(XQServiceContext serviceContext, String rmeData, XQMessage message, String code, String sender) {
        boolean ret = false;
        try {
            IRMEMessage rmeMessage = RMEMessageFactory.createInstance(serviceContext, rmeData, message, code);
            rmeMessage.send(sender, serviceContext.getParameters(), serviceContext.getQoS(), EndpointManager.getInvocationEndpointRegistry());
            ret = true;
        }
        catch (Throwable e) {
            log.logInformation("Message Rejected, rejected message could not be created for " + sender);
            log.logInformation(e);
            log.logInformation("Cause of rejected message: " + code);
            log.logInformation(rmeData);
        }
        return ret;
    }
}

