/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.expr;

import modelobjects.expr.BinaryExpression;
import modelobjects.expr.Expression;
import modelobjects.expr.PostEvalConverter;
import modelobjects.util.LexerTokenTypes;

class ShortCircuitExpression
extends BinaryExpression
implements LexerTokenTypes {
    ShortCircuitExpression(int operator, Expression operand1, Expression operand2) {
        super(operator, operand1, operand2);
    }

    @Override
    protected Object eval1(Object rootObject, PostEvalConverter cvt, int rule) throws Exception {
        Boolean a = ShortCircuitExpression.canonicalBoolean(this.operand1.eval(rootObject, cvt, rule), rule);
        switch (this.operator) {
            case -62: {
                if (a == Boolean.FALSE) {
                    return a;
                }
                return ShortCircuitExpression.canonicalBoolean(this.operand2.eval(rootObject, cvt, rule), rule);
            }
            case -63: {
                if (a == Boolean.FALSE) {
                    return ShortCircuitExpression.canonicalBoolean(this.operand2.eval(rootObject, cvt, rule), rule);
                }
                return a;
            }
        }
        throw new RuntimeException("unexpected operator in short-circuit expression: " + ShortCircuitExpression.opName(this.operator));
    }

    static Boolean canonicalBoolean(Object val, int rule) {
        if (rule == 1) {
            if (val instanceof Boolean) {
                return (Boolean)val;
            }
            throw new RuntimeException("non-boolean value: " + val);
        }
        if (val == null || val.equals(Boolean.FALSE) || "".equals(val)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

