/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.template;

import modelobjects.expr.Expression;
import modelobjects.template.SubstFragment;
import modelobjects.template.TagParser;
import modelobjects.template.TemplateFragment;
import modelobjects.template.TemplateParser;

class ShortSubstTagParser
extends TagParser {
    private static final char LSQUARE = '[';
    private static final char RSQUARE = ']';

    ShortSubstTagParser() {
    }

    @Override
    TemplateFragment extractFragment(TemplateParser parser, int startPos) {
        char[] source = parser.getTemplateSource();
        int sourceLen = source.length;
        if (source[startPos + 1] != '[') {
            return null;
        }
        int endPos = ShortSubstTagParser.tagEndPos(startPos, source, sourceLen);
        while (endPos != -1 && source[endPos - 1] != ']') {
            endPos = ShortSubstTagParser.tagEndPos(endPos + 1, source, sourceLen);
        }
        if (endPos == -1) {
            System.out.println("did not find end for short tag!");
            return null;
        }
        String exprString = new String(source, startPos + 2, endPos - startPos - 3);
        String defaultValue = "";
        Expression expression = null;
        try {
            expression = parser.getExpressionParser().parse(exprString);
        }
        catch (Exception e) {
            System.err.println("Error in subst expression: " + e);
            expression = parser.getExpressionParser().parse("\"???\"");
        }
        return new SubstFragment(startPos, endPos, exprString, expression, defaultValue);
    }
}

