/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.template;

import modelobjects.expr.Expression;
import modelobjects.template.TagParser;
import modelobjects.template.TemplateFragment;
import modelobjects.template.TemplateParser;
import modelobjects.template.TemplateProcessor;
import modelobjects.template.VariableFragment;

class VariableTagParser
extends TagParser {
    protected static final String tagStart = "<VARIABLE";
    protected static final int tagStartLength = "<VARIABLE".length();
    private transient String varName;
    private transient String varType;
    private transient String exprString;
    private transient Expression expression;

    VariableTagParser() {
    }

    @Override
    TemplateFragment extractFragment(TemplateParser parser, int startPos) {
        int sourceLen;
        char[] source = parser.getTemplateSource();
        if (!this.tagNameMatches(source, startPos, sourceLen = source.length, "VARIABLE", "variable")) {
            return null;
        }
        int endPos = VariableTagParser.tagEndPos(startPos + tagStartLength, source, source.length);
        this.collectTagInfo(parser, source, startPos, endPos);
        return new VariableFragment(startPos, endPos, this.varName, this.varType, this.exprString, this.expression);
    }

    private void collectTagInfo(TemplateParser parser, char[] source, int startPos, int endPos) {
        this.varName = null;
        this.exprString = null;
        this.expression = null;
        this.varType = null;
        String attributesString = new String(source, startPos + tagStartLength, endPos - startPos - tagStartLength);
        TagParser.TagAttribute[] attributes = this.collectAttributes(attributesString, source, startPos);
        int n = attributes.length;
        for (int i = 0; i < n; ++i) {
            String attrName = attributes[i].getAttrName();
            String attrValue = attributes[i].getAttrValue();
            if ("name".equalsIgnoreCase(attrName)) {
                this.exprString = this.varName = attrValue;
                continue;
            }
            if ("type".equalsIgnoreCase(attrName)) {
                this.varType = attrValue;
                continue;
            }
            if (!"".equals(attrName)) {
                this.varName = attrName;
                this.exprString = attrValue.equals(parser.getTopLevelId()) ? TemplateProcessor.TOP_LEVEL_OBJ_ID : attrValue;
                continue;
            }
            System.err.println("Unrecognized <VARIABLE> attibute: " + attrName + "=" + attrValue + " on line " + TemplateParser.lineNumber(source, startPos));
        }
        if (this.varName == null) {
            System.err.println("No NAME specified for <VARIABLE> tag on line " + TemplateParser.lineNumber(source, startPos));
            this.varName = "<no-name>";
        }
        if (this.exprString == null) {
            this.exprString = "null";
        }
        try {
            this.expression = parser.getExpressionParser().parse(this.exprString);
        }
        catch (Exception e) {
            System.err.println("Error in <VARIABLE> init expression on line " + TemplateParser.lineNumber(source, startPos) + ": " + e);
            this.expression = parser.getExpressionParser().parse("\"???\"");
        }
    }
}

