/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.el;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.el.ELException;

public class URLFile {
    private static final URLFile UFILE = new URLFile();
    private static final int MAX_ENTRIES = 20;
    private static final int BYTE_ARRAY_THRESHOLD = 0xA00000;
    private final Map<String, Object> cache = Collections.synchronizedMap(new LinkedHashMap<String, Object>(21, 0.75f, true){

        @Override
        public boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 20;
        }
    });

    public static String readURLStatic(String url) {
        return UFILE.readURL(url);
    }

    public static byte[] readURLAsByteArrayStatic(String url) {
        return UFILE.readURLAsByteArray(url);
    }

    public static String readURLDynamicStatic(String url) {
        return UFILE.readURLDynamic(url);
    }

    public static byte[] readURLAsByteArrayDynamicStatic(String url) {
        return UFILE.readURLAsByteArrayDynamic(url);
    }

    public String readURL(String url) {
        Object data = this.cache.get(url);
        if (data == null || !(data instanceof String)) {
            data = this.loadURL(url);
            this.cache.put(url, data);
        }
        return data.toString();
    }

    public String readURLDynamic(String url) {
        return this.loadURL(url);
    }

    public byte[] readURLAsByteArray(String url) {
        Object data = this.cache.get(url);
        if (!(data != null && data instanceof byte[] || ((byte[])(data = (Object)this.loadURLAsByteArray(url))).length >= 0xA00000)) {
            this.cache.put(url, data);
        }
        return (byte[])data;
    }

    public byte[] readURLAsByteArrayDynamic(String url) {
        return this.loadURLAsByteArray(url);
    }

    private String loadURL(String urlString) {
        BufferedReader reader = null;
        try {
            URL url = new URL(urlString);
            StringBuffer fileData = new StringBuffer(1000);
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                fileData.append(buf, 0, numRead);
            }
            reader.close();
            reader = null;
            String string = fileData.toString();
            return string;
        }
        catch (Throwable t) {
            throw new ELException("Failed to read from: " + urlString, t);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private byte[] loadURLAsByteArray(String urlString) {
        InputStream inputStream = null;
        try {
            URL url = new URL(urlString);
            inputStream = url.openStream();
            BufferedInputStream bis = new BufferedInputStream(inputStream);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = bis.read(buffer)) != -1) {
                baos.write(buffer, 0, read);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Throwable t) {
            throw new ELException("Failed to read from: " + urlString, t);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

