/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.el;

import com.sonicsw.esb.expression.el.BaseELResolver;
import com.sonicsw.esb.expression.el.XQMessageELResolver;
import com.sonicsw.esb.expression.el.XQPartConverter;
import com.sonicsw.esb.expression.el.XQPartELResolver;
import com.sonicsw.esb.expression.model.XQMessageParts;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotWritableException;

public class XQPartsELResolver
extends BaseELResolver {
    private static final XQPartConverter CONVERTER = new XQPartConverter();

    public XQPartsELResolver() {
    }

    public XQPartsELResolver(boolean readOnly) {
        super(readOnly);
    }

    public Object getValue(ELContext context, Object base, Object property) {
        Object result;
        block6: {
            result = null;
            if (this.isResolvable(base)) {
                XQMessageParts parts = (XQMessageParts)base;
                XQMessage msg = XQMessageELResolver.getMessage(context);
                try {
                    if (property instanceof Number) {
                        result = parts.get(msg, ((Number)property).intValue());
                        break block6;
                    }
                    if (property instanceof String) {
                        result = parts.get(msg, (String)property);
                        break block6;
                    }
                    throw new ELException("Failed to get part: " + property + " ");
                }
                catch (XQMessageException excp) {
                    throw new ELException("Failed to get part: " + property, (Throwable)excp);
                }
            }
        }
        if (result != null) {
            context.setPropertyResolved(true);
            context.putContext(XQPartELResolver.class, property);
        }
        return result;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (this.isResolvable(context, base, property)) {
            if (this.readOnly) {
                throw new PropertyNotWritableException("Resolver is read-only.");
            }
            XQMessageParts parts = (XQMessageParts)base;
            XQMessage msg = XQMessageELResolver.getMessage(context);
            try {
                if (value != null) {
                    if (property instanceof Number) {
                        parts.add(msg, ((Number)property).intValue(), this.convertToPart(value, null));
                    } else if (property instanceof String) {
                        parts.put(msg, (String)property, this.convertToPart(value, null));
                    } else if (property instanceof XQMessageParts.XQPartProperties) {
                        XQMessageParts.XQPartProperties props = (XQMessageParts.XQPartProperties)property;
                        XQPart part = this.convertToPart(value, props.contentType);
                        if (props.isContentIDDefined()) {
                            part.setContentId(props.contentId);
                        }
                        if (props.hasIndex()) {
                            parts.add(msg, props.index, part);
                        } else {
                            parts.add(msg, part);
                        }
                    } else {
                        return;
                    }
                }
                context.setPropertyResolved(true);
            }
            catch (XQMessageException excp) {
                throw new PropertyNotWritableException("Failed to set part: " + property, (Throwable)excp);
            }
        }
    }

    private XQPart convertToPart(Object value, String contentType) {
        return CONVERTER.convert(value, XQPart.class, contentType);
    }

    @Override
    protected final boolean isResolvable(Object base) {
        return base instanceof XQMessageParts;
    }
}

