/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.def;

import com.sonicsw.esb.itinerary.model.DynamicAddressFaultHandler;
import com.sonicsw.esb.itinerary.model.ESBProcess;
import com.sonicsw.esb.process.model.ExecutableNode;
import com.sonicsw.esb.process.model.FaultHandler;
import com.sonicsw.esb.process.model.MainProcess;
import com.sonicsw.esb.process.model.impl.DefaultFaultHandler;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import com.sonicsw.xqimpl.service.XQContainer;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;

public class FaultHandlerSerializer {
    public static final String FAULTHANDLER = "faultHandler";

    public static void parse(ExecutableNode executableNode, Element faultHandlerElem) {
        String destName = faultHandlerElem.getAttribute("endpoint_ref");
        String destType = faultHandlerElem.getAttribute("type");
        FaultHandlerSerializer.createFaultHandler(destName, destType, executableNode);
    }

    public static void parse(ExecutableNode executableNode, XMLStreamReader xsr) {
        String destName = xsr.getAttributeValue(null, "endpoint_ref");
        String destType = xsr.getAttributeValue(null, "type");
        FaultHandlerSerializer.createFaultHandler(destName, destType, executableNode);
    }

    private static void createFaultHandler(String destName, String destType, ExecutableNode executableNode) {
        if ("process".equalsIgnoreCase(destType)) {
            MainProcess fhProc = XQContainer.getProcessEngine().getProcessByName(destName);
            DefaultFaultHandler fh = new DefaultFaultHandler(executableNode);
            fh.setDefaultCatchClause(fhProc);
        } else if ("EXPRESSION".equalsIgnoreCase(destType)) {
            DynamicAddressFaultHandler fh = new DynamicAddressFaultHandler(executableNode);
            fh.setDefaultCatchClause(destName);
        } else {
            throw new IllegalArgumentException("Fault handler address " + destName + " for process " + executableNode.getParentProcess().getProcessName() + " is invalid. Fault handler should be an ESB process or an expression");
        }
    }

    public static void marshallFHStep(FaultHandler faultHandler, Writer writer, boolean isInflight) throws IOException {
        String faultHandlerElemName = null;
        faultHandlerElemName = isInflight ? "stepFaultHandler" : FAULTHANDLER;
        FaultHandler.CatchClause catchClause = faultHandler.getCatchClause("*", null);
        writer.write("<xq:" + faultHandlerElemName + " " + catchClause.getSerializationString() + "/>");
    }

    public static void setFaultHandler(ESBProcess proc, XQProcessConfig procConfig) {
        XQAddress fhAddress = procConfig.getFaultHandler();
        if (fhAddress != null) {
            if (fhAddress.getType() == 2) {
                MainProcess fhProc = XQContainer.getProcessEngine().getProcessByName(fhAddress.getName());
                DefaultFaultHandler fh = new DefaultFaultHandler(proc);
                fh.setDefaultCatchClause(fhProc);
            } else if (fhAddress.getType() == 4) {
                DynamicAddressFaultHandler fh = new DynamicAddressFaultHandler(proc);
                fh.setDefaultCatchClause(fhAddress.getName());
            } else {
                throw new IllegalArgumentException("Fault handler address " + fhAddress + " for process " + proc.getProcessName() + " is invalid. Fault handler should be an ESB process.");
            }
        }
    }
}

