/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.engine;

import com.sonicsw.esb.process.engine.ProcessChangeListener;
import com.sonicsw.esb.process.engine.ProcessState;
import com.sonicsw.esb.process.model.ActivityEdge;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Token;
import java.util.ArrayList;
import java.util.List;

public class ProcessChangeEventManager
implements com.sonicsw.esb.process.engine.ProcessChangeEventManager {
    private volatile List<ProcessChangeListener> m_notificationListenerList = new ArrayList<ProcessChangeListener>();
    private ProcessChangeListener[] m_notificationListeners = new ProcessChangeListener[0];

    @Override
    public void setProcessChangeListeners(List<ProcessChangeListener> listenerList) {
        this.m_notificationListenerList = listenerList;
        this.populateListenerArray();
    }

    @Override
    public List<ProcessChangeListener> getProcessChangeListeners() {
        return this.m_notificationListenerList;
    }

    @Override
    public synchronized void registerProcessChangeListener(ProcessChangeListener listener) {
        this.m_notificationListenerList.add(listener);
        this.populateListenerArray();
    }

    @Override
    public synchronized void removeProcessChangeListener(ProcessChangeListener listener) {
        this.m_notificationListenerList.remove(listener);
        this.populateListenerArray();
    }

    @Override
    public void processStateChanged(Token token, ProcessState newState) {
        for (int i = 0; i < this.m_notificationListeners.length; ++i) {
            this.m_notificationListeners[i].processStateChanged(token, newState);
        }
    }

    @Override
    public void transitionFired(Token token, ActivityEdge transition) {
        for (int i = 0; i < this.m_notificationListeners.length; ++i) {
            this.m_notificationListeners[i].transitionFired(token, transition);
        }
    }

    @Override
    public void activityStarted(Token token, ActivityNode activity) {
        for (int i = 0; i < this.m_notificationListeners.length; ++i) {
            this.m_notificationListeners[i].activityStarted(token, activity);
        }
    }

    @Override
    public void activityClosed(Token token, ActivityNode activity) {
        for (int i = 0; i < this.m_notificationListeners.length; ++i) {
            this.m_notificationListeners[i].activityClosed(token, activity);
        }
    }

    @Override
    public void activityTerminated(Token token, ActivityNode activity) {
        for (int i = 0; i < this.m_notificationListeners.length; ++i) {
            this.m_notificationListeners[i].activityTerminated(token, activity);
        }
    }

    @Override
    public void errorOccurred(Token token, String message) {
        for (int i = 0; i < this.m_notificationListeners.length; ++i) {
            this.m_notificationListeners[i].errorOccurred(token, message);
        }
    }

    private synchronized void populateListenerArray() {
        this.m_notificationListeners = new ProcessChangeListener[this.m_notificationListenerList.size()];
        this.m_notificationListenerList.toArray(this.m_notificationListeners);
    }
}

