/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.mapping;

import com.sonicsw.esb.expression.ExpressionContext;
import com.sonicsw.esb.expression.ExpressionFactory;
import com.sonicsw.esb.itinerary.mapping.BaseMappingRule;
import com.sonicsw.esb.process.mapping.ListParameterValue;
import com.sonicsw.esb.process.mapping.MappingAction;
import com.sonicsw.esb.process.mapping.MappingContext;
import com.sonicsw.esb.process.mapping.OutputMappingRule;
import com.sonicsw.esb.process.mapping.ParameterValueHolder;
import com.sonicsw.xq.XQMessage;

public class DefaultOutputMappingRule
extends BaseMappingRule
implements OutputMappingRule {
    public static final String MULTIPLE_MESSAGES = "MultipleMessages";
    public static final Object RESPONSE_MSG = "ResponseMessage";

    public DefaultOutputMappingRule(ExpressionFactory exprFactory, String source, String target, MappingAction action, String[] actionResources) {
        super(exprFactory, source, target, action, actionResources);
    }

    @Override
    public void mapFromOutput(XQMessage outputMsg, MappingContext mapCtx) {
        if (s_debugLogEnabled) {
            s_log.logDebug("Executing " + this.type() + " mapping rule " + this);
        }
        ExpressionContext exprCtx = (ExpressionContext)mapCtx.getObject(ExpressionContext.class, true);
        Object lhsValue = this.m_sourceExpression.getValue(exprCtx);
        if (this.m_isCollection) {
            int count = 0;
            while (lhsValue != null) {
                mapCtx.addObject("sourceCursorIndex", count + "");
                mapCtx.addObject("sourceCursorElement", lhsValue);
                lhsValue = lhsValue instanceof ParameterValueHolder ? ((ParameterValueHolder)lhsValue).getValue() : this.toSupportedSonicContent(lhsValue);
                if (s_debugLogEnabled) {
                    s_log.logDebug("Source value for collection element [" + count + "] is " + lhsValue);
                }
                Object modifiedLhsValue = this.m_action.doAction(lhsValue, this.m_actionResources, exprCtx);
                if (s_debugLogEnabled) {
                    s_log.logDebug("Performed action on collection element [" + count + "] and assigning this value to the target expression " + modifiedLhsValue);
                }
                this.m_targetExpression.setValue(exprCtx, modifiedLhsValue);
                lhsValue = this.m_sourceExpression.getValue(exprCtx);
                ++count;
            }
            ListParameterValue lpv = (ListParameterValue)exprCtx.getContextObject(ListParameterValue.class);
            if (lpv != null) {
                lpv.resetFetchCounter();
            }
        } else {
            if (lhsValue == null) {
                throw new IllegalStateException("Cannot resolve the output mapping source variable value from " + this.m_source);
            }
            if (s_debugLogEnabled) {
                s_log.logDebug("Found source value " + lhsValue);
            }
            Object modifiedLhsValue = this.m_action.doAction(lhsValue, this.m_actionResources, exprCtx);
            if (s_debugLogEnabled) {
                s_log.logDebug("Performed action and assigning this value to the target expression " + modifiedLhsValue);
            }
            this.m_targetExpression.setValue(exprCtx, modifiedLhsValue);
        }
        if (s_debugLogEnabled) {
            s_log.logDebug("Sccessfully executed " + this.type() + " mapping rule");
        }
    }

    private Object toSupportedSonicContent(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> clz = o.getClass();
        if (clz == String.class || clz.isArray() && clz.getComponentType() == Byte.TYPE) {
            return o;
        }
        return o.toString();
    }

    protected String type() {
        return "output";
    }
}

