/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.mapping;

import com.sonicsw.esb.expression.ExpressionContext;
import com.sonicsw.esb.expression.ExpressionFactory;
import com.sonicsw.esb.expression.el.ELExpressionFactory;
import com.sonicsw.esb.expression.el.ELUtils;
import com.sonicsw.esb.process.mapping.MappingContext;
import com.sonicsw.esb.process.mapping.MessageMapper;
import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQProcessContext;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.service.XQProcessContextImpl;
import com.sonicsw.xqimpl.util.xml.Namespace;
import java.util.Map;

public class MappingUtils {
    private static ExpressionContext s_exprCtx;
    private static ELExpressionFactory s_exprFactory;

    public static ExpressionContext getStaticExpressionContext() {
        MappingUtils.getStaticExpressionFactory();
        return s_exprCtx;
    }

    public static ExpressionContext getExpressionContext(XQMessage message, MappingContext mappingCtx) {
        XQServiceContext serviceContext = mappingCtx.getServiceContext();
        return MappingUtils.getExpressionContext(message, serviceContext, mappingCtx);
    }

    public static ExpressionContext getExpressionContext(XQMessage message, XQServiceContext serviceContext) {
        return MappingUtils.getExpressionContext(message, serviceContext, null);
    }

    public static ExpressionContext getExpressionContext(XQMessage message, XQServiceContext serviceContext, MappingContext mappingCtx) {
        ExpressionContext context = MappingUtils.getStaticExpressionFactory().createContext();
        if (null != mappingCtx) {
            MessageMapper msgMapper = (MessageMapper)mappingCtx.getObject(MessageMapper.class, true);
            Map<String, Namespace> nsMap = msgMapper != null ? msgMapper.getNamespaceMap() : null;
            ELUtils.setNamespaceMap(context, nsMap);
        }
        ELUtils.prepareDefaultExpressionContext(context, message, serviceContext);
        if (mappingCtx != null) {
            if (serviceContext == null) {
                XQProcessContext procCtx = (XQProcessContext)mappingCtx.getObject(XQProcessContext.class, false);
                if (procCtx != null) {
                    context.setValue("esbp", procCtx);
                } else {
                    XQParameters params = (XQParameters)mappingCtx.getObject(XQParameters.class, true);
                    context.setValue("esbp", new XQProcessContextImpl(params));
                }
            }
            context.setValue("mapctx", mappingCtx);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExpressionFactory getStaticExpressionFactory() {
        if (s_exprFactory != null) return s_exprFactory;
        Class<MappingUtils> clazz = MappingUtils.class;
        synchronized (MappingUtils.class) {
            if (s_exprFactory != null) return s_exprFactory;
            s_exprFactory = ELUtils.createExpressionFactory();
            s_exprCtx = s_exprFactory.createContext();
            s_exprCtx.setValue("system", System.getProperties());
            IComponentContext cc = XQConfigManager.getInstance(null).getComponentContext();
            if (cc == null) return s_exprFactory;
            s_exprCtx.setValue("container", cc);
            // ** MonitorExit[var0] (shouldn't be in output)
            return s_exprFactory;
        }
    }
}

