/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.mapping;

import com.sonicsw.esb.expression.ExpressionContext;
import com.sonicsw.esb.itinerary.mapping.BaseMappingAction;
import com.sonicsw.esb.process.mapping.MappingAction;
import com.sonicsw.esb.process.mapping.MappingException;
import com.sonicsw.xqimpl.script.XFormUtil;

public class XsltMappingAction
extends BaseMappingAction
implements MappingAction {
    @Override
    public Object doAction(Object content, String[] xsltURI, ExpressionContext exprCtx) {
        if (xsltURI != null && xsltURI.length > 0) {
            if (content instanceof String) {
                try {
                    XFormUtil xFormUtil = this.getXFormUtil(exprCtx);
                    return xFormUtil.computeXSLTfromURI((String)content, xsltURI[0]);
                }
                catch (MappingException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new MappingException("Error while performing [" + this.toString(content, xsltURI[0]) + "]", e);
                }
            }
            throw new MappingException("Cannot perform XSLT action on data that is not a String. Content is of type: " + content.getClass());
        }
        throw new MappingException("Cannot perform XSLT action without the XSLT path");
    }

    private String toString(Object content, String xsltURI) {
        return "Transformation using XSLT `" + xsltURI + "` for " + content;
    }

    public String toString() {
        return "XSLT";
    }
}

