/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.model.ESBProcess;
import com.sonicsw.esb.itinerary.model.EsbNode;
import com.sonicsw.esb.itinerary.model.ItineraryEndNode;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.process.model.impl.DefaultInitialNode;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.util.XQParametersImpl;

public class ItineraryStartNode
extends DefaultInitialNode {
    private boolean m_isContinuation;
    private boolean m_isNullProcess;
    private volatile XQAddress m_nextAddress;

    public ItineraryStartNode(ESBProcess parent) {
        super("initialNode", parent);
    }

    public void setEmptyProcess(boolean isNullProcess) {
        this.m_isNullProcess = isNullProcess;
    }

    public void setContinuation(boolean isContinuation) {
        this.m_isContinuation = isContinuation;
        this.setEmptyProcess(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token execute(Token token) {
        ActivityNode nextNode;
        if (this.m_isContinuation) {
            token.unTagType(Token.Type.C10N);
            return token;
        }
        if (this.m_isNullProcess) {
            XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
            ActivityNode nextNode2 = this.m_outgoingEdges[0].getDestination();
            assert (nextNode2 instanceof ItineraryEndNode);
            return ItineraryEndNode.createTokens(procInst, token, this);
        }
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        if (procInst.isSubProcess()) {
            this.populateXQParameters(token);
        }
        if ((nextNode = this.m_outgoingEdges[0].getDestination()) instanceof EsbNode) {
            if (this.m_nextAddress == null) {
                ItineraryStartNode itineraryStartNode = this;
                synchronized (itineraryStartNode) {
                    if (this.m_nextAddress == null) {
                        this.m_nextAddress = ((EsbNode)nextNode).getEndpointRef(token);
                    }
                }
            }
            ((EsbMessageExchange)token.getData()).setDestinationAddress(this.m_nextAddress);
        }
        return super.execute(token);
    }

    protected void populateXQParameters(Token token) {
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        XQParametersImpl runtimeParams = (XQParametersImpl)mex.getXQParameters();
        runtimeParams.setParameter("SonicXQ.ContainerName", 1, XQContainer.getXQContainerName());
        runtimeParams.setParameter("SonicXQ.ApplicationName", 1, ((ESBProcess)this.getParentGroup()).getDisplayName());
    }

    @Override
    public boolean activate(Token token) {
        if (!this.m_isContinuation) {
            this.executeActionList(this.m_onEntry, this.m_process.getGlobalOnEntryAction(), token);
            if (this.m_process.getOnEntryAction() != null) {
                this.executeActionList(null, this.m_process.getOnEntryAction(), token);
            }
            return super.activate(token);
        }
        return true;
    }

    @Override
    public boolean deactivate(Token token) {
        if (!this.m_isContinuation) {
            this.executeActionList(this.m_onExit, this.m_process.getGlobalOnExitAction(), token);
            return super.deactivate(token);
        }
        return true;
    }
}

