/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.message.rme;

import com.sonicsw.esb.message.rme.IRMEMessage;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xqimpl.service.RMEMessage;
import com.sonicsw.xqimpl.util.XQParametersImpl;
import javax.xml.parsers.ParserConfigurationException;

public abstract class RMEMessageFactory {
    public static IRMEMessage createInstance(XQServiceContext ctx, Throwable throwable, XQMessage message, String rejectedCode) throws XQMessageException, ParserConfigurationException {
        if (ctx == null) {
            throw new XQMessageException("RMEMessage cannot be constructed from a null ServiceContext!");
        }
        XQAddress rmeAddress = ctx.getRMEAddress();
        XQParameters environment = ctx.getParameters();
        XQMessageFactory messageFactory = ctx.getMessageFactory();
        return new RMEMessage(throwable, rmeAddress, messageFactory, message, environment, rejectedCode);
    }

    public static IRMEMessage createInstance(XQServiceContext ctx, String rmeData, XQMessage message, String rejectedCode) throws XQMessageException, ParserConfigurationException {
        if (ctx == null) {
            throw new XQMessageException("RMEMessage cannot be constructed from a null ServiceContext!");
        }
        XQAddress rmeAddress = ctx.getRMEAddress();
        XQParameters environment = ctx.getParameters();
        XQMessageFactory messageFactory = ctx.getMessageFactory();
        return new RMEMessage(rmeData, rmeAddress, messageFactory, message, environment, rejectedCode);
    }

    public static IRMEMessage createInstance(Throwable throwable, XQAddress rmeAddress, XQMessageFactory messageFactory, XQMessage message, String rejectedCode) throws XQMessageException, ParserConfigurationException {
        return RMEMessageFactory.createInstance(throwable, rmeAddress, messageFactory, message, (XQParameters)new XQParametersImpl(), rejectedCode);
    }

    public static IRMEMessage createInstance(Throwable throwable, XQAddress rmeAddress, XQMessageFactory messageFactory, XQMessage message, XQParameters environmentParam, String rejectedCode) throws XQMessageException, ParserConfigurationException {
        XQParameters environment = environmentParam;
        if (environment == null) {
            environment = new XQParametersImpl();
        }
        return new RMEMessage(throwable, rmeAddress, messageFactory, message, environment, rejectedCode);
    }
}

