/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.run.handlers.scriptengine.impl;

import com.sonicsw.esb.run.Location;
import com.sonicsw.esb.run.handlers.scriptengine.ScriptEngineLocation;

public class ScriptEngineLocationImpl
extends com.sonicsw.esb.run.impl.Location
implements ScriptEngineLocation {
    private static final long serialVersionUID = -4625347074399968915L;
    private int m_locationConstant;
    private String m_name;

    public ScriptEngineLocationImpl(String name, int locationConstant) {
        this.m_locationConstant = locationConstant;
        this.m_name = name;
    }

    @Override
    public boolean same(Location location) {
        if (super.same(location)) {
            if (location.isAnyLocation()) {
                return true;
            }
            if (location instanceof ScriptEngineLocation) {
                int constant = ((ScriptEngineLocation)location).getLocationConstant();
                String name = ((ScriptEngineLocation)location).getName();
                if (constant == this.m_locationConstant && this.m_name.equals(name)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public int getLocationConstant() {
        return this.m_locationConstant;
    }

    public String toString() {
        return "[ScriptEngineLocation: {" + this.m_name + ", " + this.constantToString(this.m_locationConstant) + "}]";
    }

    private String constantToString(int contant) {
        switch (contant) {
            case 1: {
                return "INPUTS";
            }
            case 2: {
                return "OUTPUTS";
            }
            case 3: {
                return "EVERYTHING";
            }
        }
        return null;
    }
}

