/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.connector.jms;

import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQEndpointException;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.config.XQEndpointTypeConfig;
import com.sonicsw.xqimpl.endpoint.container.EndpointCfg;
import java.util.HashMap;
import javax.jms.Destination;

public class JMSEndpointCfg
extends EndpointCfg {
    public JMSEndpointCfg(XQEndpointConfig config, XQEndpointTypeConfig typeConfig) throws XQEndpointCreationException {
        super(config, typeConfig);
    }

    public String getType() {
        return this.m_params.getParameter("type", 1);
    }

    public String getDestinationName() {
        return this.m_params.getParameter("destination", 1);
    }

    public String getMessageSelector() {
        return this.m_params.getParameter("messageSelector", 1);
    }

    public String getSelector(String serviceAppName) throws XQEndpointException {
        HashMap selectors = (HashMap)this.m_params.getParameterObject("selectors", 3);
        if (selectors == null) {
            return null;
        }
        Object selector = selectors.get(serviceAppName);
        if (!(selector instanceof String)) {
            XQEndpointException e = new XQEndpointException("Both selector must be String. It is " + selector.getClass().getName() + "now.");
            throw e;
        }
        return (String)selector;
    }

    public boolean isSharedSubscriptions() {
        String sharedSubscriptions = this.m_params.getParameter("sharedSubscriptions", 1, "true");
        return Boolean.valueOf(sharedSubscriptions);
    }

    public int getFlowToDisk() {
        int flowToDiskFlag = -1;
        try {
            flowToDiskFlag = Integer.parseInt(this.m_params.getParameter("flowToDisk", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flowToDiskFlag;
    }

    public Destination getDestination() {
        return (Destination)this.m_params.getParameterObject("destinationObject", 3);
    }

    public boolean hasDestinationObject() {
        return this.m_params.containsParameter("destinationObject", 3);
    }

    public boolean isConcurrentDurableSubscriber() {
        String conDurSub = this.m_params.getParameter("concurrentDurableSubscriber", 1, "true");
        return Boolean.valueOf(conDurSub);
    }

    public boolean isDurable() {
        String durableSubName = this.getDurableSubscriberName();
        return durableSubName != null && durableSubName.length() > 0;
    }

    public String getDurableSubscriberName() {
        String durSubName = this.m_params.getParameter("durableSubscriberName", 1);
        if (durSubName != null) {
            durSubName = durSubName.trim();
        }
        return durSubName;
    }

    public int getPriority() {
        int priority = -1;
        try {
            priority = Integer.parseInt(this.m_params.getParameter("jmsPriority", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return priority;
    }

    public int getDeliveryMode() {
        int deliveryMode = 1;
        try {
            deliveryMode = Integer.parseInt(this.m_params.getParameter("deliveryMode", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deliveryMode;
    }

    public long getTimeToLive() {
        long timeToLive = 0L;
        try {
            timeToLive = Long.parseLong(this.m_params.getParameter("timeToLive", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return timeToLive;
    }

    public long getSendTimeout() {
        long sendTimeout = 3600000L;
        try {
            sendTimeout = Long.parseLong(this.m_params.getParameter("sendTimeout", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sendTimeout;
    }

    public int getPrefetchCount() {
        int prefetchCount = 1;
        try {
            prefetchCount = Integer.parseInt(this.m_params.getParameter("prefetchCount", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prefetchCount;
    }

    public int getPrefetchThreshold() {
        int prefetchThreshold = 0;
        try {
            prefetchThreshold = Integer.parseInt(this.m_params.getParameter("prefetchThreshold", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prefetchThreshold;
    }
}

