/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.xcbr.routingRules.routingList.impl;

import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQProcessAddress;
import com.sonicsw.xq.service.xcbr.RoutingRuleException;
import com.sonicsw.xq.service.xcbr.context.InvocationContext;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.impl.BaseRoutingEndpointImpl;
import com.sonicsw.xqimpl.envelope.XQAddressFactoryImpl;

public class ESBProcessByPropertyNameImpl
extends BaseRoutingEndpointImpl {
    public ESBProcessByPropertyNameImpl(String argName) throws RoutingRuleException {
        super(argName);
    }

    @Override
    public String getRoutingType() {
        return "ESBProcess";
    }

    @Override
    public void route(InvocationContext argMessage) throws RoutingRuleException {
        super.route(argMessage);
        try {
            String propertyValue = argMessage.getNextIncoming().getMessage().getStringHeader(this.getName());
            if (propertyValue == null) {
                throw new RoutingRuleException("The message property " + this.getName() + " must specify a valid value");
            }
            if (propertyValue.length() == 0) {
                throw new RoutingRuleException("The message property " + this.getName() + " must specify a valid value");
            }
            XQAddressFactoryImpl addressFactory = (XQAddressFactoryImpl)argMessage.getAddressFactory();
            XQProcessAddress outgoingAddress = addressFactory.createSingleUseProcessAddress(propertyValue);
            argMessage.addAddressToIncoming((XQAddress)outgoingAddress);
        }
        catch (RoutingRuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RoutingRuleException(e);
        }
    }
}

