/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.endpoint.container.jca;

import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.adapter.XQConnection;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.config.XQConnectionTypeConfig;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.config.XQEndpointTypeConfig;
import com.sonicsw.xqimpl.config.XQJCADeploymentHelper;
import com.sonicsw.xqimpl.endpoint.container.ConnectionCfg;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.endpoint.container.jca.JCAConfigProperty;
import com.sonicsw.xqimpl.endpoint.container.jca.JCAConnectionManager;
import com.sonicsw.xqimpl.endpoint.container.jca.RARURLClassLoader;
import com.sonicsw.xqimpl.endpoint.container.jca.XQJCADeploymentDescriptor;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.EndpointConstants;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import javax.resource.spi.ManagedConnectionFactory;

public abstract class JCAConnection
extends ConnectionCfg
implements XQConnection {
    protected XQLog m_log;
    private URLClassLoader m_parentClassLoader;
    protected ClassLoader m_classLoader;
    protected XQJCADeploymentDescriptor m_deploymentDescriptor;
    protected XQMessageFactory m_messageFactory;
    protected JCAConnectionManager m_connectionManager;

    protected JCAConnection(URLClassLoader parentClassLoader, XQConnectionConfig config, XQConnectionTypeConfig typeConfig, XQLog log, JCAConnectionManager connectionManager, XQJCADeploymentDescriptor deploymentDescriptor, XQMessageFactory messageFactory) throws XQEndpointCreationException {
        super(config, typeConfig);
        this.m_parentClassLoader = parentClassLoader;
        this.m_log = log;
        this.m_messageFactory = messageFactory;
        this.m_connectionManager = connectionManager;
        this.initJCAConnection(deploymentDescriptor);
    }

    private void initJCAConnection(XQJCADeploymentDescriptor deploymentDescriptor) throws XQEndpointCreationException {
        XQJCADeploymentHelper deployment = this.m_typeConfig.getJCADeployment();
        this.checkDeployment(deployment);
        this.initializeClassLoader(deployment.getRARFileURI());
        this.initializeDeploymentDescriptor(deployment.getDDLocation(), deploymentDescriptor);
        this.checkDeploymentDescriptor();
    }

    public XQJCADeploymentDescriptor getDeploymentDescriptor() {
        return this.m_deploymentDescriptor;
    }

    public abstract Object getConnectionFactory();

    public abstract Endpoint createEndpoint(XQEndpointConfig var1, XQEndpointTypeConfig var2) throws XQEndpointCreationException;

    abstract ManagedConnectionFactory getManagedConnectionFactory();

    public ClassLoader getClassLoader() {
        return this.m_classLoader;
    }

    protected final void initializeClassLoader(String uri) throws XQEndpointCreationException {
        StringBuilder address = new StringBuilder("jar:");
        address.append(uri);
        address.append("!/");
        try {
            this.m_classLoader = new RARURLClassLoader(new URL(address.toString()), (ClassLoader)this.m_parentClassLoader);
        }
        catch (Exception e) {
            throw new XQEndpointCreationException("Can't access the specified RAR file.  This may be because the RAR file was not at the location specified in the ConnectionType.", (Throwable)e);
        }
    }

    protected void setBeanProperty(String name, Object target, String value, String type) throws Exception {
        BeanInfo beanInfo;
        MethodDescriptor[] methodDescriptors;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Appropriate setter method not found in the specified property: ");
        }
        Class[] typeClasses = EndpointConstants.NameToClassMap((String)type);
        if (typeClasses == null) {
            typeClasses = new Class[]{Class.forName(type)};
        }
        Object valueObj = EndpointConstants.StringToObject((String)value, (Class)typeClasses[0]);
        char first = Character.toUpperCase(name.charAt(0));
        String setterMethod = "set" + first + name.substring(1);
        Method method = this.findSetterMethod(target, setterMethod, typeClasses, methodDescriptors = (beanInfo = Introspector.getBeanInfo(target instanceof Class ? (Class<?>)target : target.getClass())).getMethodDescriptors());
        if (method != null) {
            method.invoke(target, valueObj);
        }
    }

    private Method findSetterMethod(Object target, String setterMethod, Class[] typeClasses, MethodDescriptor[] methodDescriptors) throws Exception {
        Method method = null;
        Class<?>[] paramTypes = null;
        int numMethods = methodDescriptors.length;
        boolean methodFound = false;
        for (int i = 0; i < numMethods; ++i) {
            method = methodDescriptors[i].getMethod();
            String methodName = method.getName();
            paramTypes = method.getParameterTypes();
            if (paramTypes.length != 1 || !setterMethod.equalsIgnoreCase(methodName) || !paramTypes[0].getName().equalsIgnoreCase(typeClasses[0].getName()) && !paramTypes[0].getName().equalsIgnoreCase(typeClasses[1].getName())) continue;
            methodFound = true;
            break;
        }
        if (!methodFound) {
            throw new NoSuchMethodException(JCAConnection.callToString(target.getClass(), setterMethod, new Class[]{paramTypes[0]}));
        }
        return method;
    }

    protected static String callToString(Class targetClass, String methodName, Class[] argTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append(targetClass.getName());
        if (methodName != null) {
            buf.append(".").append(methodName);
        }
        buf.append("(");
        if (argTypes != null && argTypes.length > 0) {
            buf.append(argTypes[0].getName());
            for (int i = 1; i < argTypes.length; ++i) {
                buf.append(",").append(argTypes[i].getName());
            }
        } else {
            buf.append("[none]");
        }
        buf.append(")");
        return buf.toString();
    }

    protected final void initializeDeploymentDescriptor(String ddLocation, XQJCADeploymentDescriptor dd) throws XQEndpointCreationException {
        try {
            this.m_deploymentDescriptor = dd;
            this.m_deploymentDescriptor.initFromXML(DOMUtils.getDocumentBuilder((boolean)true).parse(this.m_classLoader.getResourceAsStream(ddLocation)));
        }
        catch (Exception e) {
            throw new XQEndpointCreationException("Can't access / read / parse the specified Deployment Descriptor.  This may be because the deployment descriptor is malformed or that it is not at the location specified in the ConnectionType.", (Throwable)e);
        }
    }

    protected Object createBean(String beanClassname, JCAConfigProperty[] props, Class checkAssignable) throws XQEndpointCreationException {
        Class<?> beanClass = null;
        Object bean = null;
        try {
            beanClass = this.m_classLoader.loadClass(beanClassname);
            bean = beanClass.newInstance();
        }
        catch (Exception e) {
            throw new XQEndpointCreationException((Throwable)e);
        }
        if (!checkAssignable.isAssignableFrom(beanClass)) {
            throw new XQEndpointCreationException("Can't access / read / parse the specified Deployment Descriptor.  This may be because the deployment descriptor is malformed or that it is not at the location specified in the ConnectionType.");
        }
        try {
            for (int i = 0; i < props.length; ++i) {
                JCAConfigProperty prop = props[i];
                String name = prop.getName();
                String value = null;
                value = this.m_params.containsParameter(name, 1) ? this.m_params.getParameter(name, 1) : prop.getValue();
                if (value == null) continue;
                this.setBeanProperty(name, bean, value, prop.getType());
            }
            return bean;
        }
        catch (Exception e) {
            throw new XQEndpointCreationException((Throwable)e);
        }
    }

    protected void checkDeploymentDescriptor() throws XQEndpointCreationException {
        if (this.m_deploymentDescriptor.getManagedConnectionFactoryClass() == null || "".equals(this.m_deploymentDescriptor.getManagedConnectionFactoryClass().trim())) {
            throw new XQEndpointCreationException("Can't access / read / parse the specified Deployment Descriptor.  This may be because the deployment descriptor is malformed or that it is not at the location specified in the ConnectionType.");
        }
    }

    private void checkDeployment(XQJCADeploymentHelper deployment) throws XQEndpointCreationException {
        if (deployment == null || deployment.getDDLocation() == null || "".equals(deployment.getDDLocation().trim()) || deployment.getRARFileURI() == null || "".equals(deployment.getRARFileURI().trim())) {
            throw new XQEndpointCreationException("Bad connection configuration: ");
        }
    }
}

