/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.endpoint.container.jca;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;

public final class RARURLClassLoader
extends URLClassLoader {
    private static final boolean DEBUG = false;
    private static int BUF_SIZE = 2048;

    RARURLClassLoader() throws IOException {
        this((URL)null, (ClassLoader)null);
    }

    RARURLClassLoader(URL rarFileURL) throws IOException {
        this(rarFileURL, RARURLClassLoader.getSystemClassLoader());
    }

    RARURLClassLoader(URL rarFileURL, ClassLoader parent) throws IOException {
        super(new URL[]{rarFileURL}, parent);
        JarURLConnection cnxn = (JarURLConnection)rarFileURL.openConnection();
        if (cnxn != null) {
            Enumeration<JarEntry> entries = cnxn.getJarFile().entries();
            while (entries.hasMoreElements()) {
                URL jarURL;
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".jar") || (jarURL = this.cacheJarFile(cnxn.getJarFile().getInputStream(entry))) == null) continue;
                this.addURL(jarURL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL cacheJarFile(InputStream in) {
        OutputStream out = null;
        try {
            File tmpFile = File.createTempFile("jar_cache", ".jar");
            tmpFile.deleteOnExit();
            out = new FileOutputStream(tmpFile);
            int read = 0;
            byte[] buf = new byte[BUF_SIZE];
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
            String urlString = "jar:file://" + tmpFile.toURL().getFile() + "!/";
            URL uRL = new URL(urlString);
            return uRL;
        }
        catch (IOException e) {
            URL uRL = null;
            return uRL;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

