/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.envelope;

import com.sonicsw.xq.XQAddressFactory;
import com.sonicsw.xq.XQAddressNotFoundException;
import com.sonicsw.xq.XQEndpoint;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.endpoint.container.EndpointManager;
import com.sonicsw.xqimpl.endpoint.container.IEndpointRegistry;
import com.sonicsw.xqimpl.endpoint.container.InvocationEndpointManager;
import com.sonicsw.xqimpl.envelope.IEndpointHelper;
import com.sonicsw.xqimpl.envelope.IXQAddressImpl;
import com.sonicsw.xqimpl.envelope.XQAddressFactoryImpl;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import progress.message.jimpl.Topic;

public class XQContainerEndpointHelper
implements IEndpointHelper {
    private static final XQAddressFactoryImpl s_factory = new XQAddressFactoryImpl(null, -1);
    private static XQLog s_log = XQLogImpl.getInstance();

    @Override
    public IEndpointRegistry getEndpointManagerInstance() {
        return EndpointManager.getInstance();
    }

    @Override
    public IEndpointRegistry getInvocationEndpointRegistry() {
        return EndpointManager.getInvocationEndpointRegistry();
    }

    @Override
    public XQEndpointConfig getConfig(XQEndpoint endpoint) {
        if (endpoint instanceof Endpoint) {
            return ((Endpoint)endpoint).getConfig();
        }
        return null;
    }

    @Override
    public IXQAddressImpl createReplyToInvocationEndpointAddress(XQEndpointConfig sourceEndpointConfig, Destination destination, IEndpointRegistry reg) throws XQAddressNotFoundException {
        IXQAddressImpl result = s_factory.createInvocationEndpointAddress(sourceEndpointConfig, destination, true, (InvocationEndpointManager)reg);
        if (this.isESBClientReplyTo(destination)) {
            this.createESBClientAncillaryInvocationEndpointAddresses("Exit", sourceEndpointConfig, destination, reg);
            this.createESBClientAncillaryInvocationEndpointAddresses("Fault", sourceEndpointConfig, destination, reg);
            this.createESBClientAncillaryInvocationEndpointAddresses("RME", sourceEndpointConfig, destination, reg);
            if (this.hasTopicRoutingPrefix(destination)) {
                this.createESBClientAncillaryInvocationEndpointAddresses("ReplyTo", sourceEndpointConfig, destination, reg);
            }
        }
        return result;
    }

    private boolean isESBClientReplyTo(Destination destination) {
        if (destination instanceof Topic) {
            String topicName = ((Topic)destination).getFullName();
            return topicName.indexOf("AsynchTmp.ReplyTo") != -1 || topicName.indexOf("ClientTmp.ReplyTo") != -1;
        }
        return false;
    }

    private boolean hasTopicRoutingPrefix(Destination destination) {
        if (destination instanceof Topic) {
            return ((Topic)destination).getRouting() != null;
        }
        return false;
    }

    private void createESBClientAncillaryInvocationEndpointAddresses(String suffix, XQEndpointConfig sourceEndpointConfig, Destination replyTo, IEndpointRegistry reg) throws XQAddressNotFoundException {
        InvocationEndpointManager iem = (InvocationEndpointManager)reg;
        String topicName = ((Topic)replyTo).getFullName();
        String ancilliaryFullName = topicName.replaceFirst(".ReplyTo", "." + suffix);
        Topic ancilliary = null;
        try {
            ancilliary = new Topic(ancilliaryFullName, true);
        }
        catch (InvalidDestinationException i) {
            s_log.logError("Invalid destination:" + i.getMessage());
            s_log.logDebug((Throwable)i);
            return;
        }
        s_factory.createInvocationEndpointAddress(sourceEndpointConfig, (Destination)ancilliary, ancilliary.getTopicNameOnly(), true, iem);
    }

    @Override
    public XQAddressFactory getAddressFactory() {
        return s_factory;
    }

    @Override
    public void registerEndpoint(IEndpointRegistry reg, String name, XQEndpoint endpoint) {
        ((InvocationEndpointManager)reg).registerEndpoint(name, (Endpoint)endpoint);
    }
}

