/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.envelope;

import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQEndpoint;
import com.sonicsw.xq.XQEndpointException;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.connector.jms.XQJMSMessage;
import com.sonicsw.xqimpl.endpoint.container.IEndpointRegistry;

public class XQMessageFactoryImpl
implements XQMessageFactory {
    private XQAddress m_replyTo = null;
    private IEndpointRegistry m_endpointRegistry = null;
    private String m_correlationId = null;
    private boolean m_standalone = false;

    public XQMessageFactoryImpl() {
        this(false);
    }

    public XQMessageFactoryImpl(boolean standalone) {
        this.m_standalone = standalone;
    }

    public XQMessage createMessage(XQEndpoint endpoint) throws XQEndpointException {
        XQMessage msg = endpoint.createMessage();
        try {
            if (this.m_endpointRegistry != null && msg instanceof XQJMSMessage) {
                ((XQJMSMessage)msg).setEndpointRegistry(this.m_endpointRegistry);
            }
            msg.setReplyTo(this.m_replyTo);
            msg.setCorrelationId(this.m_correlationId);
        }
        catch (XQMessageException xQMessageException) {
            // empty catch block
        }
        return msg;
    }

    public XQMessage createMessage() {
        try {
            XQJMSMessage msg = new XQJMSMessage(this.m_standalone);
            try {
                if (this.m_endpointRegistry != null) {
                    msg.setEndpointRegistry(this.m_endpointRegistry);
                }
                msg.setReplyTo(this.m_replyTo);
                msg.setCorrelationId(this.m_correlationId);
            }
            catch (XQMessageException xQMessageException) {
                // empty catch block
            }
            return msg;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public XQMessage createMessage(XQMessage msg) {
        return (XQMessage)msg.clone();
    }

    public void setEndpointRegistry(IEndpointRegistry registry) {
        this.m_endpointRegistry = registry;
    }

    public IEndpointRegistry getEndpointRegistry() {
        return this.m_endpointRegistry;
    }

    public void setReplyTo(XQAddress replyTo) {
        this.m_replyTo = replyTo;
    }

    public XQAddress getReplyTo() {
        return this.m_replyTo;
    }

    public String getCorrelationId() {
        return this.m_correlationId;
    }

    public void setCorrelationId(String id) {
        this.m_correlationId = id;
    }
}

