/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script;

import com.sonicsw.xqimpl.script.Base64ByteArrayParameterValue;
import com.sonicsw.xqimpl.script.HexByteArrayParameterValue;
import com.sonicsw.xqimpl.script.IParameterValue;
import com.sonicsw.xqimpl.script.ParameterValue;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import com.sonicsw.xqimpl.script.StringParameterValue;
import com.sonicsw.xqimpl.script.Util;
import com.sonicsw.xqimpl.script.XMLBeanParameterValue;
import com.sonicsw.xqimpl.script.XMLParameterValue;
import com.sonicsw.xqimpl.script.XMLTypeUtils;
import java.io.IOException;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.w3c.dom.Element;

public class ParameterValueFactory {
    private boolean m_loadDTDs = false;
    private String m_encoding = null;

    public ParameterValueFactory(boolean loadDTDs) {
        this(loadDTDs, null);
    }

    public ParameterValueFactory(boolean loadDTDs, String encoding) {
        this.m_loadDTDs = loadDTDs;
        this.m_encoding = encoding;
    }

    public IParameterValue createParameterValue(String parameterName, String parameterBaseType, Element value) throws ScriptEngineException {
        if (value == null) {
            throw new ScriptEngineException("null-param-value-not-allowed", null, 0);
        }
        XMLParameterValue result = new XMLParameterValue(parameterName, value);
        result.setBaseType(parameterBaseType);
        return result;
    }

    public IParameterValue createParameterValue(String parameterName, String parameterBaseType, String value) throws ScriptEngineException {
        IParameterValue result = null;
        if (parameterBaseType != null) {
            result = XMLTypeUtils.isBase64Encoded(parameterBaseType) ? new Base64ByteArrayParameterValue(parameterName, value) : (XMLTypeUtils.isHexEncoded(parameterBaseType) ? new HexByteArrayParameterValue(parameterName, value) : new StringParameterValue(parameterName, value, this.m_loadDTDs, parameterBaseType));
        }
        if (result != null) {
            result.setBaseType(parameterBaseType);
        }
        return result;
    }

    public IParameterValue createParameterValue(String parameterName, String parameterBaseType, byte[] value) throws ScriptEngineException {
        ParameterValue result = null;
        if (XMLTypeUtils.isBase64Encoded(parameterBaseType)) {
            result = new Base64ByteArrayParameterValue(parameterName, value);
            result.setBaseType(parameterBaseType);
            return result;
        }
        if (XMLTypeUtils.isHexEncoded(parameterBaseType)) {
            result = new HexByteArrayParameterValue(parameterName, value);
            result.setBaseType(parameterBaseType);
            return result;
        }
        try {
            String string = "";
            if (value != null) {
                string = Util.createStringFromByteArray(value, this.m_encoding);
            }
            result = new StringParameterValue(parameterName, string, this.m_loadDTDs, parameterBaseType);
            result.setBaseType(parameterBaseType);
            return result;
        }
        catch (IOException e) {
            ScriptEngineException se = new ScriptEngineException(e.getMessage(), null, 0);
            se.setLinkedException(e);
            throw se;
        }
    }

    public IParameterValue createParameterValue(String parameterName, XmlAnySimpleType value) throws ScriptEngineException {
        if (value == null) {
            throw new ScriptEngineException("null-param-value-not-allowed", null, 0);
        }
        return new XMLBeanParameterValue(parameterName, value);
    }
}

