/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script;

import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.xqimpl.script.TestFSDSRef;
import com.sonicsw.xqimpl.util.ParseUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

class TestFSURLConnection
extends URLConnection {
    private long m_lastModified = 0L;
    private IBlob m_blob = null;

    public TestFSURLConnection(URL url) {
        super(url);
    }

    @Override
    public void connect() throws IOException {
        try {
            IDirectoryFileSystemService ds = TestFSDSRef.getDS();
            String file = this.url.getFile();
            if (file != null) {
                file = ParseUtil.decode((String)file);
            }
            if (ds == null) {
                throw new IOException("Directory service not initialized for the sonicfs URL connection");
            }
            IDirElement element = ds.getFSElement(file, false);
            if (element == null) {
                throw new IOException("The file '" + file + "' does not exist in the Directory Service");
            }
            this.m_blob = ds.getFSBlob(file, false);
            IAttributeSet attributes = element.getAttributes();
            Long lastModified = (Long)attributes.getAttribute("LAST_MODIFIED_TIME");
            if (lastModified != null) {
                this.m_lastModified = lastModified;
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.m_blob == null) {
            this.connect();
        }
        if (this.m_blob == null) {
            throw new IOException("File data is not available");
        }
        try {
            return this.m_blob.getBlobStream();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public long getLastModified() {
        if (this.m_blob == null) {
            try {
                this.connect();
            }
            catch (IOException ioe) {
                return 0L;
            }
        }
        return this.m_lastModified;
    }

    @Override
    public String getContentType() {
        return "application/octet-stream";
    }
}

