/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.esb.itinerary.continuation.ItineraryContinuationHelper;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQProcessContext;
import com.sonicsw.xq.XQProcessContinuation;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xqimpl.envelope.XQProcessStepRoutingAddressImpl;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class XQProcessContextImpl
implements XQProcessContext {
    private XQParameters m_params;
    private XQServiceContext m_serviceCtx;

    public XQProcessContextImpl(XQParameters params) {
        this.m_params = params;
    }

    public XQProcessContextImpl(XQParameters params, XQServiceContext serviceContext) {
        this(params);
        this.m_serviceCtx = serviceContext;
    }

    public String getName() {
        return this.m_params.getParameter("SonicXQ.ProcessName", 1);
    }

    public String getDescription() {
        return this.m_params.getParameter("SonicXQ.ProcessDesc", 1);
    }

    public int getQoS() {
        int qos = 0;
        String param = this.m_params.getParameter("SonicXQ.process.qos", 1);
        if (param != null) {
            qos = Integer.parseInt(param);
        }
        return qos;
    }

    public XQQualityofService getQualityofService() {
        XQQualityofService qos = null;
        String param = this.m_params.getParameter("SonicXQ.process.qos", 1);
        if (param != null) {
            qos = XQQualityofService.valueOf((String)param);
        }
        return qos;
    }

    public XQAddress getRMEAddress() {
        return (XQAddress)this.m_params.getParameterObject("SonicXQ.process.RMEAddress", 3);
    }

    public void setRMEAddress(XQAddress rmeAddress) {
        this.m_params.setParameterObject("SonicXQ.process.RMEAddress", 3, (Object)rmeAddress);
    }

    public XQAddress getFaultAddress() {
        return (XQAddress)this.m_params.getParameterObject("SonicXQ.process.faultAddress", 3);
    }

    public void setFaultAddress(XQAddress faultAddress) {
        this.m_params.setParameterObject("SonicXQ.process.faultAddress", 3, (Object)faultAddress);
    }

    public XQAddress getEventAddress() {
        return (XQAddress)this.m_params.getParameterObject("SonicXQ.process.eventAddress", 3);
    }

    public void setEventAddress(XQAddress eventAddress) {
        this.m_params.setParameterObject("SonicXQ.process.eventAddress", 3, (Object)eventAddress);
    }

    public int getTrackingLevel() {
        int trackingLevel = 0;
        String param = this.m_params.getParameter("SonicXQ.process.trackingLevel", 1);
        if (param != null) {
            trackingLevel = Integer.parseInt(param);
        }
        return trackingLevel;
    }

    public void setTrackingLevel(int newLevel) {
        this.m_params.setParameter("SonicXQ.process.trackingLevel", 1, String.valueOf(newLevel));
    }

    public String getTrackingID() {
        return this.m_params.getParameter("SonicXQ.process.trackingID", 1);
    }

    public void setTrackingID(String newID) {
        this.m_params.setParameterObject("SonicXQ.process.trackingID", 1, (Object)newID);
    }

    public long getTTL() {
        long ttl = 0L;
        String param = this.m_params.getParameter("SonicXQ.process.TTL", 1);
        if (param != null) {
            ttl = Long.parseLong(param);
        }
        return ttl;
    }

    public void setTTL(long newTTL) {
        this.m_params.setParameter("SonicXQ.process.TTL", 1, String.valueOf(newTTL));
    }

    public long getTimestamp() {
        long timestamp = 0L;
        String param = this.m_params.getParameter("SonicXQ.process.timestamp", 1);
        if (param != null) {
            timestamp = Long.parseLong(param);
        }
        return timestamp;
    }

    public String getStepName() {
        return this.m_params.getParameter("SonicXQ.ProcessStep", 1);
    }

    public int getStepType() {
        int stepType = 0;
        String stepTypeStr = this.m_params.getParameter("SonicXQ.ProcessStepType", 1);
        if (stepTypeStr != null) {
            try {
                stepType = Integer.parseInt(stepTypeStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stepType;
    }

    public Iterator<XQAddress> getNextAddresses() {
        HashSet nextAddrs = (HashSet)this.m_params.getParameterObject("SonicXQ.ProcessNext", 3);
        if (nextAddrs != null) {
            HashSet clonedSet = (HashSet)nextAddrs.clone();
            return clonedSet.iterator();
        }
        return null;
    }

    public XQAddress getStepAddress(String stepName) throws Exception {
        int lastColonIndex;
        if (stepName == null || stepName.length() == 0) {
            return null;
        }
        if (stepName.indexOf(":") != -1) {
            throw new Exception("Step name cannot contain ':' character.");
        }
        String currentProcessName = this.m_params.getParameter("SonicXQ.ProcessName", 1);
        String topProcessName = this.m_params.getParameter("SonicXQ.TopLevelProcessName", 1);
        String fullStepName = this.m_params.getParameter("SonicXQ.ProcessStep", 1);
        fullStepName = fullStepName != null ? ((lastColonIndex = fullStepName.lastIndexOf(":")) > 0 ? fullStepName.substring(0, lastColonIndex + 1) + stepName : stepName) : stepName;
        if (topProcessName == null) {
            topProcessName = currentProcessName;
        }
        return new XQProcessStepRoutingAddressImpl(topProcessName, fullStepName, currentProcessName, stepName);
    }

    public String getTopProcessName() {
        return this.m_params.getParameter("SonicXQ.TopLevelProcessName", 1);
    }

    public Iterator<XQAddress> getExitEndpoints() {
        HashSet exitEndpoints = (HashSet)this.m_params.getParameterObject("SonicXQ.process.exitEndpoints", 3);
        exitEndpoints = (HashSet)exitEndpoints.clone();
        return exitEndpoints.iterator();
    }

    public void setExitAddresses(Set<XQAddress> addresses) {
        this.m_params.setParameterObject("SonicXQ.process.exitEndpoints", 3, addresses);
    }

    public Set<XQAddress> getExitAddresses() {
        return (Set)this.m_params.getParameterObject("SonicXQ.process.exitEndpoints", 3);
    }

    public void addExitEndpoint(XQAddress address) {
        Set exitEndpoints = (Set)this.m_params.getParameterObject("SonicXQ.process.exitEndpoints", 3);
        exitEndpoints.add(address);
    }

    public void removeExitEndpoint(XQAddress address) {
        HashSet exitEndpoints = (HashSet)this.m_params.getParameterObject("SonicXQ.process.exitEndpoints", 3);
        exitEndpoints.remove(address);
    }

    public void removeAllExitEndpoints() {
        HashSet exitEndpoints = (HashSet)this.m_params.getParameterObject("SonicXQ.process.exitEndpoints", 3);
        exitEndpoints.clear();
    }

    public Properties getInflightProperties() {
        return (Properties)this.m_params.getParameterObject("SonicXQ.process.InflightProps", 3);
    }

    public void setInflightProperties(Properties params) {
        this.m_params.setParameterObject("SonicXQ.process.InflightProps", 3, (Object)params);
    }

    public XQProcessContinuation getProcessContinuation(XQProcessContinuation.Level level) {
        return ItineraryContinuationHelper.getContinuation(this.m_serviceCtx, level);
    }

    public XQParameters getParams() {
        return this.m_params;
    }
}

