/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.template;

import com.sonicsw.xqimpl.util.ClassUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import modelobjects.expr.EvaluationResult;
import modelobjects.expr.Expression;
import modelobjects.template.EndForeachFragment;
import modelobjects.template.TemplateException;
import modelobjects.template.TemplateFragment;
import modelobjects.template.TemplateParser;
import modelobjects.template.TemplateProcessor;

class StartForeachFragment
extends TemplateFragment {
    private int endFragIndex;
    private String elemVarName;
    private String elemType;
    private String exprString;
    private Expression expression;
    private String enumerationVarName;
    protected static int enumVarCounter = 1;

    StartForeachFragment(int startPos, int endPos, String elemVarName, String elemType, String exprString, Expression expression) {
        super(startPos, endPos);
        this.elemVarName = elemVarName;
        this.elemType = elemType;
        this.exprString = exprString;
        this.expression = expression;
        this.endFragIndex = -1;
        this.enumerationVarName = this.generateEnumerationVarName();
    }

    int getEndFragIndex() {
        return this.endFragIndex;
    }

    void setEndFragIndex(int index) {
        this.endFragIndex = index;
    }

    boolean hasMatchingEndTag() {
        return this.endFragIndex >= 0;
    }

    @Override
    void processFragment(TemplateProcessor processor) throws TemplateException {
        EvaluationResult evalResult = this.expression.evaluate(processor, processor.getPostEvalConverter(), 2);
        Enumeration iterator = this.getEnumeration(evalResult.getValue());
        processor.recordVariable(this, this.enumerationVarName, null, iterator);
        processor.recordVariable(this, this.elemVarName, null, null);
        this.startNextIteration(processor);
    }

    boolean startNextIteration(TemplateProcessor processor) {
        Enumeration iterator = (Enumeration)processor.getProperty(this.enumerationVarName);
        if (iterator.hasMoreElements()) {
            Object elem = iterator.nextElement();
            processor.typeCheck(elem, this.elemType, this.getStartPosition());
            processor.setVariable(this.elemVarName, elem);
            return true;
        }
        processor.popScope(this.enumerationVarName);
        if (this.hasMatchingEndTag()) {
            processor.setCurrentFragmentIndex(this.endFragIndex + 1);
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("<FOREACH");
        buf.append(" [" + this.startPos + ".." + this.endPos + "]");
        buf.append(this.elemVarName);
        buf.append("=");
        buf.append("'");
        buf.append(this.expression);
        buf.append("'");
        if (this.elemType != null) {
            buf.append(" TYPE='");
            buf.append(this.elemType);
            buf.append("'");
        }
        buf.append(">");
        return buf.toString();
    }

    @Override
    void postParseAnalyze(char[] templateSource, TemplateFragment[] parsedTemplate, int fragmentIndex) {
        int templateLength = parsedTemplate.length;
        int nesting = 0;
        for (int i = fragmentIndex; i < templateLength; ++i) {
            TemplateFragment frag = parsedTemplate[i];
            if (frag instanceof StartForeachFragment) {
                ++nesting;
            }
            if (!(frag instanceof EndForeachFragment) || --nesting != 0) continue;
            EndForeachFragment endFrag = (EndForeachFragment)frag;
            endFrag.setStartFrag(this);
            endFrag.setStartFragIndex(fragmentIndex);
            this.setEndFragIndex(i);
            return;
        }
        System.err.println("Error: missing </FOREACH> tag for <FOREACH ...> tag on line " + TemplateParser.lineNumber(templateSource, this.startPos));
    }

    final String generateEnumerationVarName() {
        return "<<<enumeration - " + enumVarCounter++ + ">>>";
    }

    Enumeration getEnumeration(Object obj) {
        if (obj == null) {
            return new NullEnumeration();
        }
        if (obj instanceof Enumeration) {
            return (Enumeration)obj;
        }
        if (obj instanceof Object[]) {
            return new ArrayEnumeration((Object[])obj);
        }
        if (obj instanceof Iterator) {
            return new IteratorEnumeration((Iterator)obj);
        }
        if (obj instanceof Collection) {
            return Collections.enumeration((Collection)obj);
        }
        return new UnitEnumeration(obj);
    }

    static class IteratorEnumeration
    implements Enumeration {
        Iterator iter;

        IteratorEnumeration(Iterator iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        public Object nextElement() {
            return this.iter.next();
        }
    }

    static class UnitEnumeration
    implements Enumeration {
        Object obj;
        boolean done;

        UnitEnumeration(Object obj) {
            this.obj = obj;
            this.done = false;
        }

        @Override
        public boolean hasMoreElements() {
            return !this.done;
        }

        public Object nextElement() {
            this.done = true;
            return this.obj;
        }
    }

    static class ArrayEnumeration
    implements Enumeration {
        protected Object[] array;
        int length;
        int index;

        ArrayEnumeration(Object[] array) {
            this.array = ClassUtils.arrayCopy((Object[])array);
            this.index = 0;
            this.length = array.length;
        }

        @Override
        public boolean hasMoreElements() {
            return this.index < this.length;
        }

        public Object nextElement() {
            return this.array[this.index++];
        }
    }

    static class NullEnumeration
    implements Enumeration {
        NullEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    }
}

