/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.client.impl.util;

import com.sonicsw.esb.client.ESBClientException;
import com.sonicsw.esb.client.ESBClientTimeoutException;
import com.sonicsw.esb.client.Exchange;
import com.sonicsw.esb.client.ExchangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class ExchangeTimeout
extends TimerTask {
    protected static Timer timeoutTimer = new Timer(true);
    private static Map<Object, ExchangeTimeout> listenerForExchange = Collections.synchronizedMap(new HashMap());
    private final ExchangeListener listener;
    private final Exchange exchange;
    private boolean hasRun = false;

    public static ExchangeTimeout scheduleTimedListener(ExchangeListener listener, Exchange exchange, long delay) {
        ExchangeTimeout task = new ExchangeTimeout(listener, exchange);
        timeoutTimer.schedule((TimerTask)task, delay);
        return task;
    }

    public static void cancelTimedListener(Exchange exchange) {
        ExchangeTimeout et = listenerForExchange.get(exchange);
        if (et == null) {
            return;
        }
        try {
            et.cancel();
        }
        finally {
            listenerForExchange.remove(exchange);
        }
    }

    public ExchangeTimeout(ExchangeListener listener, Exchange exchange) {
        this.listener = listener;
        this.exchange = exchange;
    }

    @Override
    public void run() {
        this.hasRun = true;
        this.listener.exchangeFailed(this.exchange, (ESBClientException)new ESBClientTimeoutException());
    }
}

