/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.engine;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.framework.MessageExchange;
import com.sonicsw.esb.itinerary.engine.ItineraryEngine;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.engine.XQProcessInstanceGenerator;
import com.sonicsw.esb.itinerary.engine.XQProcessInstanceLite;
import com.sonicsw.esb.itinerary.model.ESBProcess;
import com.sonicsw.esb.process.engine.ProcessInstance;
import com.sonicsw.esb.process.model.MainProcess;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import com.sonicsw.xqimpl.service.XQContainer;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.axis.encoding.Base64;

public class XQProcessInstanceLiteGenerator
extends XQProcessInstanceGenerator {
    public static final String CONTEXT_HDR = "SonicESB.ProcessContext";

    @Override
    public ProcessInstance newChildProcessInstance(Token token, MainProcess process, ProcessInstance parentInst, Object additionalConfig) {
        return new XQProcessInstanceLite(this, (ESBProcess)process, (XQProcessConfig)additionalConfig, (XQProcessInstance)parentInst);
    }

    @Override
    public ProcessInstance newProcessInstance(Token token, MainProcess process, Object additionalConfig) {
        return new XQProcessInstanceLite(this, process, (XQProcessConfig)additionalConfig, (EsbMessageExchange)token.getData());
    }

    @Override
    public ProcessInstance retrieveProcessInstance(Token token) {
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        try {
            String continuationStr = mex.getInputMessage().getStringHeader(CONTEXT_HDR);
            if (continuationStr == null) {
                throw new ItineraryException("SonicESB.ProcessContext header is missing.", token);
            }
            byte[] processContextBytes = Base64.decode((String)continuationStr);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(processContextBytes));
            Properties props = (Properties)ois.readObject();
            ProcessInstanceProps procInstProps = new ProcessInstanceProps(props, token);
            List<XQProcessInstanceLite.ProcessStepTuple> processStepTuples = this.createProcessStepTuple(props, token);
            if (procInstProps.getFaultHandlerTag()) {
                return null;
            }
            return new XQProcessInstanceLite(this, procInstProps, processStepTuples, token, true);
        }
        catch (ItineraryException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("Error while creating continuation header", e);
        }
    }

    private List<XQProcessInstanceLite.ProcessStepTuple> createProcessStepTuple(Properties props, Token token) {
        String stepInfo = props.getProperty("SonicXQ.ProcessStep");
        String processInfo = props.getProperty("SonicXQ.ProcessTrail");
        if (stepInfo == null) {
            throw new ItineraryException("Step name is missing", token);
        }
        if (processInfo == null) {
            throw new ItineraryException("Process name is missing", token);
        }
        StringTokenizer stepToken = new StringTokenizer(stepInfo, ":");
        StringTokenizer processToken = new StringTokenizer(processInfo, ":");
        if (stepToken.countTokens() != processToken.countTokens()) {
            throw new ItineraryException("Process and step information not matching", token);
        }
        ArrayList<XQProcessInstanceLite.ProcessStepTuple> tuples = new ArrayList<XQProcessInstanceLite.ProcessStepTuple>();
        while (stepToken.hasMoreTokens()) {
            XQProcessInstanceLite.ProcessStepTuple tuple = new XQProcessInstanceLite.ProcessStepTuple();
            tuple.stepName = stepToken.nextToken();
            tuple.processName = processToken.nextToken();
            tuples.add(tuple);
        }
        return tuples;
    }

    @Override
    public boolean hasProcessState(MessageExchange mex) {
        try {
            XQMessage msg = mex.getInputMessage();
            return msg != null && msg.getStringHeader(CONTEXT_HDR) != null;
        }
        catch (XQMessageException xQMessageException) {
            return false;
        }
    }

    ESBProcess getESBProcess(XQProcessInstanceLite procInst, XQProcessInstanceLite.ProcessStepTuple processStepTuple) {
        ItineraryEngine engine = (ItineraryEngine)XQContainer.getProcessEngine();
        XQProcessConfig procConfig = engine.lookupProcessConfig(processStepTuple.processName, null);
        ESBProcess currentProcess = engine.getProcessByName(processStepTuple.processName, procConfig);
        procInst.setProcessConfig(procConfig);
        return currentProcess;
    }
}

