/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.mapping;

import com.sonicsw.esb.expression.ExpressionContext;
import com.sonicsw.esb.itinerary.mapping.BaseMappingAction;
import com.sonicsw.esb.process.mapping.MappingAction;
import com.sonicsw.esb.process.mapping.MappingException;
import com.sonicsw.xqimpl.util.Base64;
import com.sonicsw.xqimpl.util.HexBin;

public class BinaryDecodeAction
extends BaseMappingAction
implements MappingAction {
    @Override
    public Object doAction(Object content, String[] resources, ExpressionContext exprCtx) {
        byte[] byteContent = null;
        String strContent = null;
        if (content instanceof byte[]) {
            byteContent = (byte[])content;
        } else if (content instanceof String) {
            strContent = (String)content;
        } else {
            throw new MappingException("Cannot perform decoding action if data is not a String or byte array. Content is of type: " + content.getClass());
        }
        String decodingType = resources[0] == null ? "Base64" : resources[0];
        try {
            if (decodingType.equalsIgnoreCase("Base64")) {
                if (byteContent != null) {
                    return Base64.decode((byte[])byteContent);
                }
                return Base64.decode((String)strContent);
            }
            if (decodingType.equalsIgnoreCase("HexBinary")) {
                if (byteContent != null) {
                    return HexBin.decode((byte[])byteContent);
                }
                return HexBin.decode((String)strContent);
            }
            throw new MappingException("Unknown encoding type " + decodingType);
        }
        catch (MappingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new MappingException("Error while performing [" + this.toString(content, decodingType) + "]", e);
        }
    }

    private String toString(Object content, String encodingType) {
        return "Decode to binary data from a string or byte array with `" + encodingType + "` encoding";
    }

    public String toString() {
        return "BinaryDecode";
    }
}

