/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.mapping;

import com.sonicsw.esb.expression.ExpressionContext;
import com.sonicsw.esb.itinerary.mapping.BaseMappingAction;
import com.sonicsw.esb.process.mapping.MappingAction;
import com.sonicsw.esb.process.mapping.MappingException;
import com.sonicsw.xqimpl.script.XFormUtil;
import com.sonicsw.xqimpl.util.Base64;

public class WrapInXmlMappingAction
extends BaseMappingAction
implements MappingAction {
    @Override
    public Object doAction(Object content, String[] resources, ExpressionContext exprCtx) {
        if (resources != null && resources.length > 0) {
            String contentStr = null;
            if (content instanceof byte[]) {
                contentStr = new String(Base64.encode((byte[])((byte[])content)));
            } else if (content instanceof String) {
                contentStr = (String)content;
            } else {
                if (content == null) {
                    throw new MappingException("Cannot perform " + this.toString(content, resources[0]));
                }
                throw new MappingException("Cannot perform " + this.toString(content, resources[0]) + ". Content is of type: " + content.getClass());
            }
            try {
                XFormUtil xFormUtil = this.getXFormUtil(exprCtx);
                return xFormUtil.wrapAsXML(resources[0], contentStr);
            }
            catch (MappingException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new MappingException("Error while performing [" + this.toString(content, resources[0]) + "]", e);
            }
        }
        throw new MappingException("Error while performing wrapping action as the wrapper XML name is null");
    }

    private String toString(Object content, String wrapperElem) {
        return "Wrap as XML Element with `" + wrapperElem + "` for " + content;
    }

    public String toString() {
        return "wrapInXML";
    }
}

