/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.FaultProcessInstance;
import com.sonicsw.esb.itinerary.engine.ItineraryEngine;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.itinerary.engine.ProcessTracker;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.model.CompositeToken;
import com.sonicsw.esb.itinerary.model.ESBProcess;
import com.sonicsw.esb.itinerary.model.EsbNode;
import com.sonicsw.esb.itinerary.model.ItineraryEndNode;
import com.sonicsw.esb.process.caching.CachingDefinition;
import com.sonicsw.esb.process.engine.ProcessInstance;
import com.sonicsw.esb.process.mapping.MessageMapper;
import com.sonicsw.esb.process.model.ActivityGroup;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.process.model.impl.DataToken;
import com.sonicsw.esb.process.model.impl.DefaultExecutableNode;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQProcessAddress;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import com.sonicsw.xqimpl.config.XQTrackingDetailsConfig;
import com.sonicsw.xqimpl.envelope.EnvelopeFactory;
import com.sonicsw.xqimpl.service.CriticalException;
import com.sonicsw.xqimpl.service.MessageAlreadyRejected;
import com.sonicsw.xqimpl.service.MessageSendingHelper;
import com.sonicsw.xqimpl.service.RMEMessage;
import com.sonicsw.xqimpl.service.RejectedMessageDispatcher;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQDispatcher;
import com.sonicsw.xqimpl.service.XQRegistry;
import com.sonicsw.xqimpl.util.XQParametersImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EsbStepNode
extends DefaultExecutableNode
implements EsbNode {
    protected XQAddress m_endpointRef;
    protected XQParameters m_stepParams;
    protected MessageMapper m_messageMapper;
    private Set<XQAddress> m_nextAddresses;
    private boolean m_nextAddressesDynamic;
    private EnvelopeFactory m_envelopeFactory;
    private boolean m_canExecuteInContainer;
    private CachingDefinition m_cachingDefinition;

    public EsbStepNode(String id, ActivityGroup parent) {
        super(id, parent);
    }

    @Override
    public void setEndpointRef(XQAddress endpointRef) {
        this.m_endpointRef = endpointRef;
        this.m_canExecuteInContainer = EsbStepNode.canExecuteInContainer(endpointRef);
    }

    @Override
    public XQAddress getEndpointRef(Token token) {
        return this.m_endpointRef;
    }

    @Override
    public void setMessageMapper(MessageMapper msgMapper) {
        this.m_messageMapper = msgMapper;
    }

    @Override
    public MessageMapper getMessageMapper() {
        return this.m_messageMapper;
    }

    public CachingDefinition getCachingDefinition() {
        return this.m_cachingDefinition;
    }

    public void setCachingDefinition(CachingDefinition cachingDefinition) {
        this.m_cachingDefinition = cachingDefinition;
    }

    @Override
    public Token execute(Token token) {
        Token resultToken;
        block27: {
            EsbMessageExchange mex = (EsbMessageExchange)token.getData();
            resultToken = null;
            try {
                if (token.isTokenOfType(Token.Type.C10N, true)) {
                    token.changeOwnership(this, false);
                    return token;
                }
                if (s_debugLogEnabled) {
                    s_log.logDebug(this + ": Executing step");
                }
                XQAddress endpointRef = this.getEndpointRef(token);
                String serviceName = endpointRef.getName();
                XQDispatcher dispatcher = XQRegistry.instance().lookupService(serviceName);
                mex.setDestinationAddress(endpointRef);
                XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
                if (s_debugLogEnabled) {
                    s_log.logDebug(this + ": Sending to destination " + endpointRef);
                }
                this.overrideMessageExchange(mex, token, dispatcher);
                if (endpointRef.getType() == 0) {
                    XQContainer.getProcessEngine().getProcessInstanceSerializerFactory().createProcessInstanceSerializer().serialize(this, token);
                    MessageSendingHelper.sendToAddress(mex, procInst.getProcessDefinition().getProcessName() + "." + this.m_id);
                    break block27;
                }
                if (endpointRef.getType() == 1) {
                    Token rmeToken = this.verifySufficientQos(mex, token);
                    if (rmeToken != null) {
                        return rmeToken;
                    }
                    rmeToken = this.verifyTTLExpired(mex, token);
                    if (rmeToken != null) {
                        return rmeToken;
                    }
                    if (this.m_messageMapper != null) {
                        mex.getXQParameters().setParameterObject(MessageMapper.class.getName(), 3, (Object)this.m_messageMapper);
                    }
                    if (this.m_cachingDefinition != null) {
                        mex.getXQParameters().setParameterObject(CachingDefinition.class.getName(), 3, (Object)this.m_cachingDefinition);
                    }
                    this.doExecute(mex, dispatcher, procInst);
                    if (mex.getSendBox() != null) {
                        RMEMessage rmeMsg = mex.getSendBox().getRME();
                        if (rmeMsg != null) {
                            if (s_debugLogEnabled) {
                                s_log.logDebug(this + ": Processing rejected messages");
                            }
                            EsbMessageExchange newMex = (EsbMessageExchange)mex.clone();
                            newMex.setInputMessage(mex.getInputMessage());
                            newMex.setRMEMessage(rmeMsg);
                            newMex.setXQDispatcher(dispatcher);
                            rmeToken = new DataToken((ActivityNode)this, (ProcessInstance)procInst, newMex);
                            rmeToken.tagType(Token.Type.RME);
                            resultToken = rmeToken;
                        } else {
                            ArrayList<Token> resultTokens = new ArrayList<Token>();
                            ArrayList<EsbMessageExchange> resultMexs = new ArrayList<EsbMessageExchange>();
                            mex.setInFaultProcess(procInst instanceof FaultProcessInstance);
                            List<XQEnvelope> envList = mex.getSendBox().getFaultbox();
                            if (envList != null && !envList.isEmpty()) {
                                if (s_debugLogEnabled) {
                                    s_log.logDebug(this + ": Processing faultbox");
                                }
                                MessageSendingHelper.populateFaultbox(mex, envList, dispatcher, resultMexs);
                                this.createTokens(token, resultTokens, resultMexs, Token.Type.FAULT, procInst);
                                resultMexs.clear();
                            }
                            if ((envList = mex.getSendBox().getOutbox()) != null && !envList.isEmpty()) {
                                if (s_debugLogEnabled) {
                                    s_log.logDebug(this + ": Processing outbox");
                                }
                                MessageSendingHelper.populateOutbox(mex, envList, dispatcher, resultMexs);
                                this.createTokens(token, resultTokens, resultMexs, Token.Type.DATA, procInst);
                            }
                            if (resultTokens.isEmpty()) {
                                EsbMessageExchange nullMex = (EsbMessageExchange)mex.clone();
                                nullMex.setDestinationAddress(null);
                                resultToken = new DataToken((ActivityNode)this, (ProcessInstance)procInst, nullMex);
                                resultToken.tagType(Token.Type.NULL);
                            } else if (resultTokens.size() == 1) {
                                resultToken = (Token)resultTokens.get(0);
                            } else {
                                CompositeToken compositeToken = new CompositeToken(this, procInst);
                                for (int i = 0; i < resultTokens.size(); ++i) {
                                    compositeToken.addToken((Token)resultTokens.get(i));
                                }
                                resultToken = compositeToken;
                            }
                        }
                    } else {
                        XQTrackingDetailsConfig trackingDetails;
                        ProcessTracker pTracker = procInst.getprocessTracker();
                        if (pTracker != null && (trackingDetails = pTracker.getTrackingDetails()).getTrackingLevel() != 5) {
                            pTracker.sendTrackingMessage("SERVICE_EXIT", null, mex.getDestinationAddress(), mex, 2);
                        }
                    }
                    break block27;
                }
                if (endpointRef.getType() == 2) {
                    XQProcessAddress procAddr = XQContainer.getAddressFactory().createProcessAddress(endpointRef.getName());
                    mex.setDestinationAddress((XQAddress)procAddr);
                    resultToken = token.changeOwnership(this, false);
                    resultToken.setProperty("PARENT_PROCESS_INSTANCE", token.getProcessInstance());
                    break block27;
                }
                throw new ItineraryException(null, "Unsupported address type", token);
            }
            catch (Throwable e) {
                EsbStepNode.handleException(e, this, token, mex);
            }
        }
        return resultToken;
    }

    static void handleException(Throwable e, EsbNode node, Token token, EsbMessageExchange mex) {
        if (e instanceof ItineraryException) {
            ((ItineraryException)e).setCurrentNode(node);
            throw (ItineraryException)e;
        }
        if (!(e instanceof MessageAlreadyRejected)) {
            if (e instanceof CriticalException) {
                throw (CriticalException)e;
            }
            if (e instanceof RuntimeException) {
                if (mex.isExchangeImmediate()) {
                    String ctxMsg = "Error executing step " + node + " due to Exception: " + e.getMessage();
                    throw new ItineraryException(e, ctxMsg, token, node);
                }
                throw (RuntimeException)e;
            }
            String ctxMsg = "Error executing step " + node + " due to Exception: " + e.getMessage();
            throw new ItineraryException(e, ctxMsg, token, node);
        }
    }

    protected void doExecute(EsbMessageExchange mex, XQDispatcher dispatcher, XQProcessInstance procInst) throws Throwable {
        XQParametersImpl params = (XQParametersImpl)mex.getXQParameters();
        params.setDirtyFlag(false);
        if (mex.isExchangeImmediate()) {
            dispatcher.onMessageImmediate(mex);
        } else {
            dispatcher.onMessage(mex);
        }
        if (params.isDirty()) {
            ProcessInstanceProps procInstProps = procInst.getProcessInstanceProperties();
            procInstProps.setFromEnvironment(mex.getXQParameters());
            if (procInst.getprocessTracker() != null) {
                procInst.getprocessTracker().override(procInstProps);
            } else if (procInstProps.getTrackingLevel() > 0) {
                ProcessTracker tracker = new ProcessTracker(procInstProps);
                procInst.setProcessTracker(tracker);
            }
        }
    }

    private void createTokens(Token token, List<Token> resultTokens, List<EsbMessageExchange> resultMexs, Token.Type tokenType, XQProcessInstance procInst) {
        int existingCount = resultTokens.size();
        for (int i = 0; i < resultMexs.size(); ++i) {
            XQTrackingDetailsConfig trackingDetails;
            EsbMessageExchange mex = resultMexs.get(i);
            Token newToken = null;
            if (existingCount + i > 0) {
                newToken = new DataToken((ActivityNode)this, (ProcessInstance)procInst.clone(), mex);
                if (this.m_outgoingEdges[0].getDestination() instanceof ItineraryEndNode) {
                    newToken.setProperty("MULTIPLE_TOKEN", Boolean.TRUE);
                }
            } else {
                newToken = token.changeOwnership(this, false);
                newToken.setProcessInstance(procInst);
                newToken.setData(mex);
            }
            newToken.tagType(tokenType);
            if (mex.getRMEMessage() != null) {
                newToken.tagType(Token.Type.RME);
            }
            resultTokens.add(newToken);
            ProcessTracker pTracker = procInst.getprocessTracker();
            if (pTracker == null || (trackingDetails = pTracker.getTrackingDetails()).getTrackingLevel() == 5) continue;
            pTracker.sendTrackingMessage("SERVICE_EXIT", mex.getInputMessage(), mex.getDestinationAddress(), mex, 2);
        }
    }

    @Override
    public void offerOutgoing(Token token) {
        if (token.getProperty("PARENT_PROCESS_INSTANCE") == null) {
            super.offerOutgoing(token);
        } else {
            try {
                token.setFromActivityNode(null);
                token.setProcessInstance(null);
                ((ItineraryEngine)XQContainer.getProcessEngine()).initiateProcess(token);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ItineraryException(e, "TODO", token);
            }
        }
    }

    private void overrideMessageExchange(EsbMessageExchange mex, Token token, XQDispatcher dispatcher) {
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        Set<XQAddress> nextAddrs = this.overrideEnvelopeFactory(mex, procInst, token, dispatcher);
        mex.setRMEAddress(procInst.getProcessInstanceProperties().getRMEAddress());
        this.populateXQParameters(mex, procInst, nextAddrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<XQAddress> overrideEnvelopeFactory(EsbMessageExchange mex, XQProcessInstance procInst, Token token, XQDispatcher dispatcher) {
        HashSet<XQAddress> nextAddrs = null;
        EnvelopeFactory envelopeFactory = null;
        if (this.m_nextAddressesDynamic) {
            nextAddrs = new HashSet(4);
            procInst.computeNextAddresses(this, nextAddrs, token);
            envelopeFactory = EsbStepNode.createEnvelopeFactory(procInst, token, nextAddrs, this.m_endpointRef, dispatcher);
        } else {
            if (this.m_nextAddresses == null) {
                EsbStepNode esbStepNode = this;
                synchronized (esbStepNode) {
                    if (this.m_nextAddresses == null) {
                        nextAddrs = new HashSet(4);
                        procInst.computeNextAddresses(this, nextAddrs, token);
                        this.m_nextAddressesDynamic = token.getProperty("NextAddrDynamic") != null;
                        envelopeFactory = EsbStepNode.createEnvelopeFactory(procInst, token, nextAddrs, this.m_endpointRef, dispatcher);
                        if (!this.m_nextAddressesDynamic) {
                            this.m_nextAddresses = nextAddrs;
                            this.m_envelopeFactory = envelopeFactory;
                        }
                    } else {
                        nextAddrs = this.m_nextAddresses;
                        envelopeFactory = (EnvelopeFactory)this.m_envelopeFactory.clone();
                    }
                }
            } else {
                nextAddrs = this.m_nextAddresses;
                envelopeFactory = (EnvelopeFactory)this.m_envelopeFactory.clone();
            }
            procInst.setNextAddresses(nextAddrs);
        }
        ProcessInstanceProps props = procInst.getProcessInstanceProperties();
        XQAddress fe = props.getFaultAddress();
        if (fe == null) {
            if (procInst.getProcessConfig().getFaultEndpoint() != null) {
                fe = procInst.getProcessConfig().getFaultEndpoint();
            } else if (dispatcher != null) {
                fe = dispatcher.getServiceHandler().getFaultAddress();
            }
        }
        if (fe != null) {
            envelopeFactory.setFaultAddress(fe);
        }
        mex.setEnvelopeFactory(envelopeFactory);
        return nextAddrs;
    }

    private static EnvelopeFactory createEnvelopeFactory(XQProcessInstance procInst, Token token, Set<XQAddress> nextAddrs, XQAddress endpointRef, XQDispatcher dispatcher) {
        EnvelopeFactory envelopeFactory = new EnvelopeFactory();
        String isLastStep = (String)token.removeProperty("NextAddrDynamic");
        if (nextAddrs.isEmpty() && "isLastStep".equals(isLastStep)) {
            XQProcessConfig procConfig = procInst.getProcessConfig();
            Set exits = procConfig.getExitEndpoints();
            if (exits != null && !exits.isEmpty()) {
                nextAddrs.addAll(exits);
            } else if (endpointRef.getType() == 1 && dispatcher != null) {
                nextAddrs.addAll(dispatcher.getServiceConfig().getExitEndpoints());
            }
        }
        if (!nextAddrs.isEmpty()) {
            for (XQAddress address : nextAddrs) {
                envelopeFactory.addOutputAddress(address);
            }
        }
        return envelopeFactory;
    }

    static XQParameters populateBasicXQParameters(Token token, EsbNode node, XQDispatcher dispatcher) {
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        ESBProcess currentProcess = (ESBProcess)procInst.getProcessDefinition();
        ProcessInstanceProps pip = procInst.getProcessInstanceProperties();
        XQParametersImpl procCtxParams = new XQParametersImpl();
        pip.addToEnvironment((XQParameters)procCtxParams);
        procCtxParams.setParameter("SonicXQ.ProcessName", 1, currentProcess.getProcessName());
        procCtxParams.setParameter("SonicXQ.ProcessDesc", 1, procInst.getProcessConfig().getDescription());
        procCtxParams.setParameter("SonicXQ.TopLevelProcessName", 1, pip.getRootProcessName());
        procCtxParams.setParameter("SonicXQ.ProcessStepType", 1, String.valueOf(mex.getDestinationAddress().getType()));
        procCtxParams.setParameter("SonicXQ.ProcessStep", 1, procInst.getCompleteStepName(node.getDisplayName()));
        procCtxParams.setParameterObject("SonicESB.process.Token", 3, (Object)token);
        if (procInst.getprocessTracker() != null) {
            procInst.getprocessTracker().populateTrackingProps((XQParameters)procCtxParams, pip);
        }
        if (procInst instanceof FaultProcessInstance) {
            XQMessage msg = mex.getInputMessage();
            EsbStepNode.setProcCtxParam((XQParameters)procCtxParams, "SonicXQ.FaultSource.TopLevelProcessName", msg, "SonicESB.RME.TopProcess");
            EsbStepNode.setProcCtxParam((XQParameters)procCtxParams, "SonicXQ.FaultSource.ProcessName", msg, "SonicESB.RME.Process");
            EsbStepNode.setProcCtxParam((XQParameters)procCtxParams, "SonicXQ.FaultSource.ProcessStep", msg, "SonicESB.RME.Step");
            EsbStepNode.setProcCtxParam((XQParameters)procCtxParams, "SonicXQ.FaultSource.ContainerName", msg, "SonicESB.RME.XQContainer");
            EsbStepNode.setProcCtxParam((XQParameters)procCtxParams, "SonicXQ.FaultSource.HostName", msg, "SonicESB.RME.Host");
            EsbStepNode.setProcCtxParam((XQParameters)procCtxParams, "SonicXQ.FaultSource.ServiceName", msg, "SonicESB.RME.XQService");
            EsbStepNode.setProcCtxParam((XQParameters)procCtxParams, "SonicXQ.FaultSource.FaultCode", msg, "SonicESB.RME.Code", "SonicESB.Fault.Code");
            EsbStepNode.setProcCtxParam((XQParameters)procCtxParams, "SonicXQ.FaultSource.FaultMessage", msg, "SonicESB.RME.Message", "SonicESB.Fault.String");
            EsbStepNode.setProcCtxParam((XQParameters)procCtxParams, "SonicXQ.FaultSource.FaultName", msg, "SonicESB.Fault.Name");
            EsbStepNode.setProcCtxParam((XQParameters)procCtxParams, "SonicXQ.FaultSource.FaultSubCode", msg, "SonicESB.Fault.SubCode");
            mex.setInFaultProcess(true);
        }
        if (dispatcher != null) {
            procCtxParams.setParent(dispatcher.getBasicParameters());
        }
        return procCtxParams;
    }

    private static void setProcCtxParam(XQParameters procCtxParams, String paramName, XQMessage msg, String msgHeader) {
        try {
            procCtxParams.setParameter(paramName, 1, msg.getStringHeader(msgHeader));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void setProcCtxParam(XQParameters procCtxParams, String paramName, XQMessage msg, String msgHeader1, String msgHeader2) {
        try {
            String value = msg.getStringHeader(msgHeader1);
            if (value != null) {
                procCtxParams.setParameter(paramName, 1, value);
            } else {
                value = msg.getStringHeader(msgHeader2);
                procCtxParams.setParameter(paramName, 1, value);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void populateXQParameters(EsbMessageExchange mex, XQProcessInstance procInst, Set<XQAddress> nextAddrs) {
        XQParametersImpl runtimeParams = (XQParametersImpl)mex.getXQParameters();
        if (this.m_stepParams != null) {
            runtimeParams.copyParameters(this.m_stepParams);
        }
        runtimeParams.setParameter("SonicXQ.ProcessStep", 1, procInst.getCompleteStepName(this.m_displayName));
        runtimeParams.setParameterObject("SonicXQ.ProcessNext", 3, nextAddrs);
    }

    @Override
    public boolean activate(Token token) {
        if (token.isTokenOfType(Token.Type.C10N, false)) {
            return true;
        }
        XQDispatcher dispatcher = this.validateMessageExchange(token);
        XQParameters params = EsbStepNode.populateBasicXQParameters(token, this, dispatcher);
        ((EsbMessageExchange)token.getData()).setXQParameters(params);
        return super.activate(token);
    }

    @Override
    public void setXQParameters(XQParameters params) {
        this.m_stepParams = params;
    }

    @Override
    public XQParameters getXQParameters() {
        return this.m_stepParams;
    }

    public Set<XQAddress> getNextAddresses() {
        return this.m_nextAddresses;
    }

    protected XQDispatcher validateMessageExchange(Token token) {
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        assert (mex != null);
        XQAddress destXQAddress = mex.getDestinationAddress();
        if (destXQAddress == null) {
            throw new ItineraryException("Cannot process message as destination address not found", token);
        }
        if (!this.m_canExecuteInContainer) {
            throw new ItineraryException("The address: `" + this.m_endpointRef + "` for step: `" + this + "` cannot be executed in this container", token);
        }
        mex.setInProcess(true);
        XQDispatcher dispatcher = XQRegistry.instance().lookupService(this.m_endpointRef.getName());
        mex.setXQDispatcher(dispatcher);
        return dispatcher;
    }

    private Token verifySufficientQos(EsbMessageExchange mex, Token token) {
        DataToken rmeToken = null;
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        ProcessInstanceProps processProps = procInst.getProcessInstanceProperties();
        XQQualityofService processQOS = processProps.getQualityOfService();
        XQQualityofService serviceQOS = mex.getQOS();
        boolean ok = true;
        if (processQOS.equals(XQQualityofService.EXACTLY_ONCE) && !serviceQOS.equals(XQQualityofService.EXACTLY_ONCE)) {
            ok = false;
        } else if (processQOS.equals(XQQualityofService.AT_LEAST_ONCE) && (serviceQOS.equals(XQQualityofService.BEST_EFFORT_DISCARDABLE) || serviceQOS.equals(XQQualityofService.BEST_EFFORT) || serviceQOS.equals(XQQualityofService.AT_LEAST_ONCE_FAST))) {
            ok = false;
        } else if (processQOS.equals(XQQualityofService.AT_LEAST_ONCE_FAST) && (serviceQOS.equals(XQQualityofService.BEST_EFFORT_DISCARDABLE) || serviceQOS.equals(XQQualityofService.BEST_EFFORT))) {
            ok = false;
        } else if (processQOS.equals(XQQualityofService.BEST_EFFORT) && serviceQOS.equals(XQQualityofService.BEST_EFFORT_DISCARDABLE)) {
            ok = false;
        }
        if (!ok) {
            XQServiceException exception = new XQServiceException("Insufficient QoS to process message. Minimum QoS required `" + processQOS + "`. QoS of endpoint on which message was received `" + serviceQOS + "`");
            s_log.logError((Throwable)exception);
            try {
                RejectedMessageDispatcher rmeDispatcher = ((ItineraryEngine)XQContainer.getProcessEngine()).getRMEDispatcher(mex);
                XQMessage rmeMessage = rmeDispatcher.createRMEMessage(exception, mex.getInputMessage(), mex.getRMEAddress(), "PROCESS_QOS_UNSUPPORTED_AT_ENDPOINT", mex.getXQParameters(), mex.getEndpointContext(), mex.getMessageFactory(), "");
                mex.setInputMessage(rmeMessage);
            }
            catch (Exception e) {
                throw new ItineraryException(e, "Error creating RME for Qos violation", token);
            }
            rmeToken = new DataToken((ActivityNode)this, (ProcessInstance)token.getProcessInstance(), mex);
            rmeToken.tagType(Token.Type.RME);
        }
        return rmeToken;
    }

    private Token verifyTTLExpired(EsbMessageExchange mex, Token token) throws ItineraryException {
        DataToken rmeToken = null;
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        ProcessInstanceProps processProps = procInst.getProcessInstanceProperties();
        long ttl = processProps.getTTL();
        long timestamp = processProps.getTimeStamp();
        if (timestamp == 0L) {
            processProps.setTimeStamp(System.currentTimeMillis());
        }
        if (ttl > 0L && timestamp > 0L && System.currentTimeMillis() >= timestamp + ttl) {
            XQServiceException exception = new XQServiceException("Cannot process the message as Process TTL has expired");
            s_log.logError((Throwable)exception);
            try {
                RejectedMessageDispatcher rmeDispatcher = ((ItineraryEngine)XQContainer.getProcessEngine()).getRMEDispatcher(mex);
                XQMessage rmeMessage = rmeDispatcher.createRMEMessage(exception, mex.getInputMessage(), mex.getRMEAddress(), "TIME_TO_LIVE_EXPIRED", mex.getXQParameters(), mex.getEndpointContext(), mex.getMessageFactory(), "");
                mex.setInputMessage(rmeMessage);
            }
            catch (Exception e) {
                throw new ItineraryException(e, "Error creating RME for Qos violation", token);
            }
            rmeToken = new DataToken((ActivityNode)this, (ProcessInstance)token.getProcessInstance(), mex);
            rmeToken.tagType(Token.Type.RME);
        }
        return rmeToken;
    }

    static boolean canExecuteInContainer(XQAddress destAddr) {
        if (destAddr.getType() == 1) {
            String svcName = destAddr.getName();
            return ItineraryEngine.isReservedServiceName(svcName) || XQContainer.isInternalContainerComponent(svcName) || XQRegistry.instance().lookupService(svcName) != null;
        }
        return destAddr.getType() != 4;
    }
}

