/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.xcbr.routingRules;

import com.sonicsw.xq.service.xcbr.RoutingRuleException;
import com.sonicsw.xq.service.xcbr.configuration.CBRConfiguration;
import com.sonicsw.xq.service.xcbr.configuration.CBRConfigurationFactory;
import com.sonicsw.xq.service.xcbr.routingRules.RoutingRules;
import com.sonicsw.xq.service.xcbr.routingRules.impl.RoutingRulesImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RoutingRulesFactory {
    private static final int MAX_CACHE_SIZE = 100;
    private static Map<String, RoutingRules> cachedRules_ = new ConcurrentHashMap<String, RoutingRules>();

    public static RoutingRules create(CBRConfiguration argConfiguration) throws RoutingRuleException {
        return new RoutingRulesImpl(argConfiguration.getRoutingRules());
    }

    public static boolean isCached(String argRoutingRules) throws RoutingRuleException {
        return cachedRules_.get(argRoutingRules) != null;
    }

    public static RoutingRules getRoutingRulesFromCache(String argRoutingRules) throws RoutingRuleException {
        RoutingRules returnValue = cachedRules_.get(argRoutingRules);
        if (returnValue == null) {
            CBRConfiguration config = CBRConfigurationFactory.create(argRoutingRules);
            returnValue = RoutingRulesFactory.create(config);
            if (cachedRules_.size() < 100) {
                cachedRules_.put(argRoutingRules, returnValue);
            }
        }
        return returnValue;
    }

    public static void addRoutingRules(String argRoutingRulesKey, RoutingRules argRoutingRules) throws RoutingRuleException {
        if (RoutingRulesFactory.isCached(argRoutingRulesKey)) {
            throw new RoutingRuleException("The routing rules are already cached");
        }
        cachedRules_.put(argRoutingRulesKey, argRoutingRules);
    }
}

