/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.xcbr.routingRules.routingList.impl;

import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.service.xcbr.RoutingRuleException;
import com.sonicsw.xq.service.xcbr.context.InvocationContext;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.impl.BaseRoutingEndpointImpl;

public class ESBEndpointRoutingEndpointImpl
extends BaseRoutingEndpointImpl {
    private boolean m_isReplyTo;

    public ESBEndpointRoutingEndpointImpl(String argName, boolean isReplyTo) throws RoutingRuleException {
        super(argName);
        this.m_isReplyTo = isReplyTo;
    }

    public ESBEndpointRoutingEndpointImpl(String argName) throws RoutingRuleException {
        this(argName, false);
    }

    @Override
    public void route(InvocationContext argMessage) throws RoutingRuleException {
        super.route(argMessage);
        try {
            if (this.isDefaultOutbox()) {
                argMessage.addDefaultAddressesToIncoming();
            } else {
                XQAddress outgoingAddress = this.getOutgoingAddress(argMessage);
                argMessage.addAddressToIncoming(outgoingAddress);
            }
        }
        catch (RoutingRuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RoutingRuleException(e);
        }
    }

    private XQAddress getOutgoingAddress(InvocationContext argMessage) throws RoutingRuleException {
        try {
            XQAddress returnValue = null;
            returnValue = this.m_isReplyTo || this.isReplyTo() ? argMessage.getAddressFactory().getReplyToAddress() : argMessage.getAddressFactory().createEndpointAddress(this.getName());
            return returnValue;
        }
        catch (RoutingRuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RoutingRuleException(e);
        }
    }

    private boolean isReplyTo() throws RoutingRuleException {
        String name = this.getName();
        return name.compareToIgnoreCase("replyto") == 0 || name.compareToIgnoreCase("reply_to") == 0;
    }

    private boolean isDefaultOutbox() throws RoutingRuleException {
        String name = this.getName();
        return name.compareToIgnoreCase("outbox") == 0 || name.compareToIgnoreCase("default") == 0 || name.compareToIgnoreCase("exit") == 0;
    }

    @Override
    public String getRoutingType() {
        return "ESBEndpoint";
    }
}

