/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script;

import com.sonicsw.xqimpl.util.xml.Namespace;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Namespaces {
    private List<Namespace> m_nameSpaceList = new ArrayList<Namespace>();
    private Map<String, Namespace> m_nameSpaceMap = new HashMap<String, Namespace>();

    public Namespaces(Element namespacesElm) throws MalformedURLException {
        this.deserializeNamespaces(namespacesElm);
    }

    private void deserializeNamespaces(Element namespacesElm) throws MalformedURLException {
        NodeList tempNl = namespacesElm.getChildNodes();
        for (int i = 0; i < tempNl.getLength(); ++i) {
            String schemaLocation;
            String prefix;
            Node n = tempNl.item(i);
            if (!(n instanceof Element) || !n.getLocalName().equals("ns")) continue;
            Element e = (Element)n;
            Namespace ns = new Namespace();
            String namespaceURI = e.getAttribute("uri");
            if (namespaceURI != null && !"".equals(namespaceURI)) {
                ns.setNamespaceUri(namespaceURI);
            }
            if ((prefix = e.getAttribute("prefix")) != null && !"".equals(prefix)) {
                ns.setPrefix(e.getAttribute("prefix"));
                this.m_nameSpaceMap.put(prefix, ns);
            }
            if ((schemaLocation = e.getAttribute("schemaLocation")) != null && !"".equals(schemaLocation)) {
                ns.setSchemaLocation(new URL(schemaLocation));
            }
            this.m_nameSpaceList.add(ns);
        }
    }

    public List<Namespace> getNamespaceList() {
        return this.m_nameSpaceList;
    }

    public String getNamespaceURI(String prefix) {
        Namespace ns = this.m_nameSpaceMap.get(prefix);
        if (ns != null) {
            return ns.getNamespaceUri();
        }
        return null;
    }
}

