/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script.wsdl;

import com.sonicsw.esb.ws.invocation.ESBWSTypeLibrary;
import com.sonicsw.xqimpl.script.wsdl.All;
import com.sonicsw.xqimpl.script.wsdl.ExactlyOne;
import com.sonicsw.xqimpl.script.wsdl.NormalizedPolicy;
import com.sonicsw.xqimpl.script.wsdl.PolicyElement;
import com.sonicsw.xqimpl.script.wsdl.WSDLConstants;
import com.sonicsw.xqimpl.script.wsdl.WSDLHelper;
import com.sonicsw.xqimpl.script.wsdl.WSDLHelperException;
import com.sonicsw.xqimpl.script.wsdl.WSDLServiceHelper;
import com.sonicsw.xqimpl.util.URLUtil;
import com.sonicsw.xqimpl.util.xml.Namespace;
import com.sonicsw.xqimpl.util.xml.XMLUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpression;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.value.SequenceExtent;
import org.w3c.dom.Element;

public class Policy {
    static QName WSP_POLICY_QNAME = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy");
    protected static QName WSP_POLICY_REFERENCE_QNAME = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference");
    protected static QName WSP_POLICY_URIS_ATTR_QNAME = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyURIs");
    static QName WSP_POLICY_EXACTLY_ONE_QNAME = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "ExactlyOne");
    static QName WSP_POLICY_ALL_QNAME = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "All");
    protected static List POLICY_QNAMES = new ArrayList();
    private PolicyElement m_policyElement = null;
    private String m_serializedForm = null;
    private static XMLUtils m_xmlUtils;

    Policy(WSDLServiceHelper svcHelper, ExtensibilityElement exElem) throws WSDLHelperException {
        this(svcHelper, ((UnknownExtensibilityElement)exElem).getElement());
    }

    private Policy(PolicyElement p) {
        this.m_policyElement = p;
    }

    public Policy(String location, Element elemParam) throws WSDLHelperException {
        Element elem = elemParam;
        QName elemQName = this.validateURIGetQName(elem);
        if (elemQName.equals(WSDLConstants.WS_POLICY_REFERENCE_QNAME)) {
            String uri = elem.getAttribute("URI");
            elem = Policy.getReferencedPolicyElement(location, uri);
        }
        this.m_policyElement = this.computeNormalForm(elem);
    }

    public Policy(WSDLServiceHelper svcHelper, Element elem) throws WSDLHelperException {
        QName elemQName = this.validateURIGetQName(elem);
        if (elemQName.equals(WSDLConstants.WS_POLICY_REFERENCE_QNAME)) {
            String uri = elem.getAttribute("URI");
            elem = Policy.findReferencedPolicyElement(svcHelper, uri);
        }
        this.m_policyElement = this.computeNormalForm(elem);
    }

    private QName validateURIGetQName(Element elem) throws WSDLHelperException {
        if (!elem.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2004/09/policy")) {
            throw new WSDLHelperException("extensibility-element-is-not-policy", null);
        }
        QName elemQName = new QName(elem.getNamespaceURI(), elem.getLocalName());
        return elemQName;
    }

    public Policy(WSDLServiceHelper svcHelper, String uri) throws WSDLHelperException {
        Element elem = Policy.findReferencedPolicyElement(svcHelper, uri);
        this.m_policyElement = this.computeNormalForm(elem);
    }

    public String serialize() {
        if (this.m_serializedForm == null && this.m_policyElement != null) {
            this.m_serializedForm = this.m_policyElement.serialize("   ");
        }
        return this.m_serializedForm;
    }

    private static PolicyElement mergePolicies(List policies) throws WSDLHelperException {
        Object p;
        ArrayList<List> alternatives = new ArrayList<List>();
        for (int i = 0; i < policies.size(); ++i) {
            p = (Policy)policies.get(i);
            alternatives.add(((Policy)p).getAlternatives());
        }
        List cp = PolicyElement.computeCrossProduct(alternatives);
        p = new NormalizedPolicy();
        ExactlyOne eo = new ExactlyOne();
        for (int i = 0; i < cp.size(); ++i) {
            All a = new All((List)cp.get(i));
            a.applyAssociativity();
            eo.addChild(a);
        }
        ((PolicyElement)p).addChild(eo);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean hasRMAssertion(String xml) {
        if (xml == null) {
            return false;
        }
        try {
            XPathExpression expr;
            XMLUtils util = Policy.getXMLUtils();
            SequenceExtent v = null;
            int len = 0;
            XPathExpression xPathExpression = expr = util.retrieveExpression("//wsrm:RMAssertion");
            synchronized (xPathExpression) {
                v = util.computeXPath(xml, expr);
                len = v.getLength();
            }
            return len > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static synchronized XMLUtils getXMLUtils() throws Exception {
        boolean cacheEnabled = true;
        if (m_xmlUtils == null) {
            ArrayList<Namespace> nspaces = new ArrayList<Namespace>();
            nspaces.add(new Namespace("wsrm", "http://schemas.xmlsoap.org/ws/2005/02/rm/policy"));
            nspaces.add(new Namespace("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd"));
            nspaces.add(new Namespace("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy"));
            m_xmlUtils = new XMLUtils(nspaces, cacheEnabled);
        }
        return m_xmlUtils;
    }

    static boolean isPolicy(QName qname) {
        return POLICY_QNAMES.contains(qname) || qname.equals(WSP_POLICY_REFERENCE_QNAME) || qname.equals(WSP_POLICY_URIS_ATTR_QNAME);
    }

    public static Policy computeEffectivePolicy(List policies) throws WSDLHelperException {
        if (!policies.isEmpty()) {
            PolicyElement p = Policy.mergePolicies(policies);
            return new Policy(p);
        }
        return new Policy(null);
    }

    private static Element findReferencedPolicyElement(WSDLServiceHelper svcHelper, String uri) throws WSDLHelperException {
        Element elem = Policy.getReferencedPolicyElement(svcHelper.getLocation(), uri);
        if (elem != null) {
            return elem;
        }
        WSDLHelper helper = svcHelper.getWSDLHelper();
        ESBWSTypeLibrary types = helper.getTypeLibrary();
        Iterator iter = types.getImportLocations();
        while (iter.hasNext()) {
            String location = (String)iter.next();
            elem = Policy.getReferencedPolicyElement(location, uri);
            if (elem == null) continue;
            return elem;
        }
        throw new WSDLHelperException("referenced-policy-not-found", new Object[]{uri});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element getReferencedPolicyElement(String baseLocation, String uri) throws WSDLHelperException {
        try {
            XPathExpression expr;
            URL url = new URL(new URL(baseLocation), uri);
            String doc = URLUtil.getURLContentsAsString((URL)url);
            String policyXPath = null;
            XMLUtils util = Policy.getXMLUtils();
            String id = url.getRef();
            policyXPath = id != null ? "//wsp:Policy[@wsu:Id=\"" + id + "\"]" : "/wsp:Policy";
            SequenceExtent v = null;
            int xpLen = 0;
            XPathExpression xPathExpression = expr = util.retrieveExpression(policyXPath);
            synchronized (xPathExpression) {
                v = util.computeXPath(doc, expr);
                xpLen = v.getLength();
                if (xpLen == 0) {
                    return null;
                }
                if (xpLen > 1) {
                    throw new WSDLHelperException("reference-maps-to-more-than-one", new Object[]{uri});
                }
                Item item = v.itemAt(0);
                if (!(item instanceof NodeInfo)) {
                    throw new WSDLHelperException("policy-is-not-a-node", new Object[]{uri});
                }
                return (Element)NodeOverNodeInfo.wrap((NodeInfo)((NodeInfo)item));
            }
        }
        catch (Exception e) {
            throw new WSDLHelperException(e);
        }
    }

    private PolicyElement computeNormalForm(Element elem) throws WSDLHelperException {
        NormalizedPolicy p = new NormalizedPolicy(elem);
        ((PolicyElement)p).normalize();
        return p;
    }

    private List getAlternatives() {
        assert (this.m_policyElement instanceof NormalizedPolicy);
        NormalizedPolicy np = (NormalizedPolicy)this.m_policyElement;
        ExactlyOne eo = (ExactlyOne)np.getChildren().get(0);
        ArrayList<List> alternatives = new ArrayList<List>();
        for (int i = 0; i < eo.getChildren().size(); ++i) {
            All a = (All)eo.getChildren().get(i);
            alternatives.add(a.getChildren());
        }
        return alternatives;
    }

    static List getPolicyElements(WSDLServiceHelper svcHelper, List elems) throws WSDLHelperException {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        for (ExtensibilityElement ex : elems) {
            if (!Policy.isPolicy(ex.getElementType())) continue;
            policies.add(new Policy(svcHelper, ex));
        }
        return policies;
    }

    static List getPolicyFromAttributes(WSDLServiceHelper svcHelper, Map m) throws WSDLHelperException {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        for (QName attrName : m.keySet()) {
            if (!Policy.isPolicy(attrName)) continue;
            Object uriObj = m.get(attrName);
            String value = null;
            if (uriObj instanceof QName) {
                String ns = ((QName)uriObj).getNamespaceURI();
                if (ns == null || ns.length() == 0) {
                    value = ((QName)uriObj).getLocalPart();
                }
            } else if (uriObj instanceof String) {
                value = (String)uriObj;
            }
            if (value == null) continue;
            policies.add(new Policy(svcHelper, value));
        }
        return policies;
    }

    static {
        POLICY_QNAMES.add(WSP_POLICY_QNAME);
        POLICY_QNAMES.add(WSP_POLICY_EXACTLY_ONE_QNAME);
        POLICY_QNAMES.add(WSP_POLICY_ALL_QNAME);
        m_xmlUtils = null;
    }
}

