/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.xqimpl.util.spring.SonicResourceLoader;
import java.util.List;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.PropertiesBeanDefinitionReader;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ResourceLoader;

public final class ESBSpringUtils {
    public static final String CTX_NAME_ROOT = "ESBRootApplicationContext";
    public static final String CTX_NAME_SHARED = "ESBSharedApplicationContext";
    public static final String CTX_NAME_SERVICE = "ESBServiceApplicationContext_";
    public static final String CTX_NAME_LOCATOR_KEY = "ESBServiceApplicationContext_LocatorKey_";
    public static final String BEAN_LOG = "xqLog";
    public static final String BEAN_CONFIG_MGR = "xqConfigManager";
    public static final String BEAN_COMPONENT_CTX = "containerComponentContext";
    public static final String BEAN_FILE_CHANGE_MGR = "fileChangeManager";
    public static final String BEAN_SHARED_CTX_CONFIGS = "sharedApplicationContextConfigs";
    public static final String SERVICE_CTX_CONFIG_PATTERN = "classpath*:config/esb/serviceAppContext.xml";
    public static final String CONTAINER_CTX_CONFIG_PATTERN = "classpath*:config/esb/containerAppContext.xml";
    public static final String GENERAL_CONFIG_PATTERN = "classpath*:META-INF/sonic/*.xml";
    public static final String GENERAL_CONFIG_BASE = "classpath:META-INF/sonic/";
    private static final ResourceLoader sonicResourceLoader = new SonicResourceLoader();

    private ESBSpringUtils() {
    }

    public static final void readBeanConfigurations(List configs, BeanDefinitionRegistry beanRegistry) {
        if (configs.isEmpty()) {
            return;
        }
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader(beanRegistry);
        PropertiesBeanDefinitionReader propReader = new PropertiesBeanDefinitionReader(beanRegistry);
        for (String location : configs) {
            if (location.endsWith(".properties") || location.endsWith(".schemas") || location.endsWith(".handlers")) {
                propReader.loadBeanDefinitions(location);
                continue;
            }
            xmlReader.loadBeanDefinitions(location);
        }
    }

    public static final void readBeanConfigurationsFromClassPath(String pattern, BeanDefinitionRegistry beanRegistry) {
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader(beanRegistry);
        if (pattern.equals(GENERAL_CONFIG_PATTERN) && !reader.getResourceLoader().getResource(GENERAL_CONFIG_BASE).exists()) {
            return;
        }
        reader.loadBeanDefinitions(pattern);
    }

    public static GenericApplicationContext createApplicationContext(String displayName) {
        return ESBSpringUtils.createApplicationContext(displayName, sonicResourceLoader);
    }

    public static GenericApplicationContext createApplicationContext(String displayName, ResourceLoader resourceLoader) {
        GenericApplicationContext ctx = new GenericApplicationContext();
        ctx.setDisplayName(displayName);
        ctx.setResourceLoader(resourceLoader);
        return ctx;
    }

    public static final Object laySpringAspects(Class intf, Object o, ApplicationContext ac) {
        if (ac != null) {
            String[] pfs = ac.getBeanNamesForType(ProxyFactoryBean.class);
            for (int i = 0; i < pfs.length; ++i) {
                String name = pfs[i];
                ProxyFactoryBean pf = null;
                pf = !name.startsWith("&") ? (ProxyFactoryBean)ac.getBean("&" + name) : (ProxyFactoryBean)ac.getBean(name);
                if (!pf.isInterfaceProxied(intf)) continue;
                pf.setTarget(o);
                Object po = pf.getObject();
                return po;
            }
        }
        return o;
    }
}

