/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.FaultProcessInstance;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.process.model.Action;
import com.sonicsw.esb.process.model.ActivityEdge;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQProcessAddress;
import com.sonicsw.xqimpl.service.XQContainer;

public class OverrideProcessFromHeadersAction
implements Action {
    @Override
    public void execute(Token token, Action.Type actionType, ActivityNode targetNode, ActivityEdge targetEdge) {
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        if (procInst.isSubProcess() || procInst instanceof FaultProcessInstance) {
            return;
        }
        XQMessage msg = ((EsbMessageExchange)token.getData()).getInputMessage();
        XQAddress destAddr = ((EsbMessageExchange)token.getData()).getDestinationAddress();
        if (!(destAddr instanceof XQProcessAddress)) {
            return;
        }
        String param = null;
        XQAddress addr = null;
        int delim = 58;
        int delimIndex = -1;
        String type = null;
        try {
            String addrName;
            ProcessInstanceProps pip = procInst.getProcessInstanceProperties();
            if (msg.containsHeader("SonicXQ.process.RMEAddress")) {
                param = msg.getStringHeader("SonicXQ.process.RMEAddress");
                msg.removeHeader("SonicXQ.process.RMEAddress");
                if (param == null || "".equals(param.trim())) {
                    pip.setRMEAddress(null);
                } else {
                    delimIndex = param.indexOf(58);
                    if (delimIndex != -1) {
                        addrName = param.substring(0, delimIndex);
                        type = param.substring(delimIndex + 1);
                        addr = XQContainer.getAddressFactory().createAddress(addrName, type);
                        pip.setRMEAddress(addr);
                    } else {
                        throw new ItineraryException("Invalid override header: " + param, token);
                    }
                }
            }
            if (msg.containsHeader("SonicXQ.process.faultAddress")) {
                param = msg.getStringHeader("SonicXQ.process.faultAddress");
                msg.removeHeader("SonicXQ.process.faultAddress");
                if (param == null || "".equals(param.trim())) {
                    pip.setFaultAddress(null);
                } else {
                    delimIndex = param.indexOf(58);
                    if (delimIndex != -1) {
                        addrName = param.substring(0, delimIndex);
                        type = param.substring(delimIndex + 1);
                        addr = XQContainer.getAddressFactory().createAddress(addrName, type);
                        pip.setFaultAddress(addr);
                    } else {
                        throw new ItineraryException("Invalid override header: " + param, token);
                    }
                }
            }
            if (msg.containsHeader("SonicXQ.process.trackingLevel")) {
                param = msg.getStringHeader("SonicXQ.process.trackingLevel");
                msg.removeHeader("SonicXQ.process.trackingLevel");
                int level = Integer.parseInt(param);
                if (level < 0 || level > 5) {
                    throw new ItineraryException("Invalid tracking level", token);
                }
                pip.setTrackingLevel(level);
            }
            if (msg.containsHeader("SonicXQ.process.trackingID")) {
                param = msg.getStringHeader("SonicXQ.process.trackingID");
                msg.removeHeader("SonicXQ.process.trackingID");
                pip.setTrackingId(param);
            }
            if (msg.containsHeader("SonicXQ.process.eventAddress")) {
                param = msg.getStringHeader("SonicXQ.process.eventAddress");
                msg.removeHeader("SonicXQ.process.eventAddress");
                if (param == null || "".equals(param.trim())) {
                    pip.setTrackingEndpoint(null);
                } else {
                    delimIndex = param.indexOf(58);
                    if (delimIndex != -1) {
                        addrName = param.substring(0, delimIndex);
                        type = param.substring(delimIndex + 1);
                        addr = XQContainer.getAddressFactory().createAddress(addrName, type);
                        pip.setTrackingEndpoint(addr);
                    } else {
                        throw new ItineraryException("Invalid override header: " + param, token);
                    }
                }
            }
            if (msg.containsHeader("SonicXQ.process.TTL")) {
                param = msg.getStringHeader("SonicXQ.process.TTL");
                msg.removeHeader("SonicXQ.process.TTL");
                long ttl = Long.parseLong(param);
                pip.setTTL(ttl);
            }
        }
        catch (ItineraryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ItineraryException(e, "Error processing process overrides", token);
        }
    }
}

