/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.run.event.impl;

import com.sonicsw.esb.run.Location;
import com.sonicsw.esb.run.LocationContext;
import com.sonicsw.esb.run.RemoteValue;
import com.sonicsw.esb.run.RunException;
import com.sonicsw.esb.run.impl.util.RunUtils;
import com.sonicsw.esb.run.request.EventRequest;
import java.rmi.Remote;
import java.rmi.RemoteException;
import net.jini.export.Exporter;

public abstract class Event
implements com.sonicsw.esb.run.event.Event {
    private IEventSynchronizer m_syncProxy = null;
    private transient IEventSynchronizer m_unExportedSyncProxy = null;
    private transient Exporter m_syncExporter = null;
    protected final Location m_location;
    protected final com.sonicsw.esb.run.request.impl.EventRequest m_request;
    protected RemoteValue m_remoteValue = null;
    protected boolean m_pingTestContextOnSuspend = false;

    public Event(LocationContext locationContext, com.sonicsw.esb.run.request.impl.EventRequest request) throws RunException {
        try {
            this.m_unExportedSyncProxy = new EventSynchronizer();
            this.m_syncExporter = locationContext.getExporterFactory().createExporter();
            this.m_syncProxy = (IEventSynchronizer)this.m_syncExporter.export((Remote)this.m_unExportedSyncProxy);
            this.m_location = locationContext.getLocation();
            this.m_request = request;
            this.m_remoteValue = locationContext.getRemoteLocationData();
        }
        catch (Exception e) {
            throw new RunException("Failed to create Event object", e);
        }
    }

    public void close() {
        if (this.m_syncExporter != null) {
            this.m_syncExporter.unexport(true);
            this.m_syncExporter = null;
        }
        if (this.m_remoteValue instanceof com.sonicsw.esb.run.impl.RemoteValue) {
            ((com.sonicsw.esb.run.impl.RemoteValue)this.m_remoteValue).close();
            this.m_remoteValue = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public Location getLocation() {
        return this.m_location;
    }

    @Override
    public EventRequest getRequest() {
        return this.m_request;
    }

    @Override
    public RemoteValue getData() {
        return this.m_remoteValue;
    }

    @Override
    public void resume() throws RunException {
        try {
            this.m_syncProxy.resume();
            this.close();
        }
        catch (RemoteException e) {
            RunException te = RunUtils.createRunException(e);
            throw te;
        }
        catch (Exception e) {
            throw new RunException("Failed to resume Run", e);
        }
    }

    public void suspend() throws RunException {
        try {
            this.m_unExportedSyncProxy.suspend();
        }
        catch (RemoteException e) {
            RunException ex = RunUtils.createRunException(e);
            throw ex;
        }
        catch (Exception e) {
            throw new RunException("Failed to suspend Run", e);
        }
    }

    public String toString() {
        return this.getClass().getName() + " @ " + this.getLocation();
    }

    public class EventSynchronizer
    implements IEventSynchronizer {
        private static final long m_pingInterval = 5000L;
        private boolean[] m_hasBeenResumed = new boolean[]{false};

        @Override
        public synchronized void resume() throws RemoteException {
            this.m_hasBeenResumed[0] = true;
            this.notifyAll();
        }

        @Override
        public synchronized void suspend() throws RemoteException {
            while (!this.m_hasBeenResumed[0]) {
                try {
                    this.wait(5000L);
                    if (this.m_hasBeenResumed[0] || !Event.this.m_pingTestContextOnSuspend) continue;
                    Event.this.m_request.getRunProxy().ping();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.m_hasBeenResumed[0] = false;
        }
    }

    public static interface IEventSynchronizer
    extends Remote {
        public void resume() throws RemoteException;

        public void suspend() throws RemoteException;
    }
}

