/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.run.impl.util;

import com.sonicsw.esb.jeri.JERIException;
import com.sonicsw.esb.jeri.jms.JMSPreferredSessionTracker;
import com.sonicsw.esb.run.RunException;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xq.connector.jms.JMSConnectionCfg;
import com.sonicsw.xq.connector.jms.JMSEndpointCfg;
import com.sonicsw.xq.connector.jms.MappingException;
import com.sonicsw.xq.connector.jms.XQJMSMessageMapper;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.config.XQConnectionTypeConfig;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.config.XQEndpointTypeConfig;
import com.sonicsw.xqimpl.config.XQServiceConfig;
import java.io.ByteArrayOutputStream;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.Message;
import javax.jms.Session;
import progress.message.jclient.ConnectionFactory;
import progress.message.jclient.ConnectionStateChangeListener;

public class XQUtils {
    public static JMSInfo retrieveJMSInfo(String serviceName) throws RunException {
        try {
            JMSInfo result = new JMSInfo();
            XQConfigManager mgr = XQConfigManager.getInstance(null);
            XQServiceConfig config = mgr.lookupServiceConfig(serviceName);
            String entryEndpoint = config.getEntryEndpoint();
            XQEndpointConfig endpointConfig = mgr.lookupEndpointConfig(entryEndpoint);
            String endpointType = endpointConfig.getEndpointType();
            XQEndpointTypeConfig endpointTypeConfig = mgr.lookupEndpointTypeConfig(endpointType);
            String connectionName = endpointConfig.getConnection();
            XQConnectionConfig connectionConfig = mgr.lookupConnectionConfig(connectionName);
            String connectionType = connectionConfig.getConnectionTypeName();
            XQConnectionTypeConfig connectionTypeConfig = mgr.lookupConnectionTypeConfig(connectionType);
            JMSEndpointCfg endpointCfg = new JMSEndpointCfg(endpointConfig, endpointTypeConfig);
            result.m_destinationName = endpointCfg.getDestinationName();
            result.m_destinationType = endpointCfg.getType();
            JMSConnectionCfg connectionCfg = new JMSConnectionCfg(connectionConfig, connectionTypeConfig);
            String resolvedConnectionURLs = mgr.getResolvedConnectionURLs(connectionName);
            result.m_url = resolvedConnectionURLs == null || resolvedConnectionURLs.isEmpty() ? connectionCfg.getURL() : resolvedConnectionURLs;
            result.m_username = connectionCfg.getUser();
            result.m_password = connectionCfg.getPassword();
            return result;
        }
        catch (Exception e) {
            RunException te = new RunException(e);
            throw te;
        }
    }

    public static Connection registerJMSPreferredSession(JMSInfo info, final String uuid) throws JERIException {
        try {
            ConnectionFactory factory = new ConnectionFactory(info.m_url);
            progress.message.jclient.Connection connection = (progress.message.jclient.Connection)factory.createConnection(info.m_username, info.m_password);
            Session clientSession = connection.createSession(false, 1);
            Session exporterSession = connection.createSession(false, 1);
            connection.start();
            connection.setConnectionStateChangeListener(new ConnectionStateChangeListener(){

                public void connectionStateChanged(int state) {
                    switch (state) {
                        case 2: 
                        case 3: {
                            JMSPreferredSessionTracker.getInstance().removeInvocation(uuid);
                            break;
                        }
                    }
                }
            });
            JMSPreferredSessionTracker.getInstance().addSession(uuid, clientSession);
            JMSPreferredSessionTracker.getInstance().addExporter(uuid, exporterSession);
            return connection;
        }
        catch (Exception e) {
            JERIException jeri = new JERIException(e.getMessage());
            jeri.initCause((Throwable)e);
            throw jeri;
        }
    }

    public static XQMessage populateMessageWithRunServiceProps(XQMessage msg, Properties props, String runType) throws RunException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            props.store(bos, null);
            XQPart part = msg.createPart((Object)bos.toByteArray(), "application/octet-stream");
            part.setContentId("SonicESB.RUN_SERVICE_PROPS");
            part.getHeader().setValue("RUN_TYPE", runType);
            msg.addPart(part);
            return msg;
        }
        catch (Exception e) {
            throw new RunException(e);
        }
    }

    public static XQMessage createXQMessageFromJMSMessage(Message msg) throws RunException {
        try {
            return XQJMSMessageMapper.create().translateOutput(msg, null);
        }
        catch (MappingException e) {
            throw new RunException((Throwable)((Object)e));
        }
    }

    public static Message createJMSMessageFromXQMessage(XQMessage msg) throws RunException {
        try {
            return (Message)XQJMSMessageMapper.create().translateInput(msg, null);
        }
        catch (MappingException e) {
            throw new RunException((Throwable)((Object)e));
        }
    }

    public static class JMSInfo {
        public String m_url;
        public String m_username;
        public String m_password;
        public String m_destinationName;
        public String m_destinationType;
    }
}

